<?php $__env->startSection('title', config('app.name', 'ultimatePOS')); ?>
<?php $request = app('Illuminate\Http\Request'); ?>
<?php $__env->startSection('content'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Justiz POS Pro | Streamline Your Business in Kenya</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Reset and Base Styles */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Arial', sans-serif;
    }

    body {
      line-height: 1.6;
      color: #333;
    }

    /* Header */
    header {
      background: linear-gradient(rgba(0,0,0,0.8), rgba(0,0,0,0.8)), url('https://images.unsplash.com/photo-1600880292203-757bb62b4baf');
      background-size: cover;
      color: white;
      padding: 2rem 1rem;
      text-align: center;
    }

    nav {
      display: flex;
      justify-content: space-between;
      max-width: 1200px;
      margin: 0 auto;
    }

    .logo {
      font-size: 1.5rem;
      font-weight: bold;
    }

    /* Hero Section */
    .hero {
      padding: 4rem 1rem;
      max-width: 800px;
      margin: 0 auto;
    }

    .hero h1 {
      font-size: 2.5rem;
      margin-bottom: 1rem;
    }

    .cta-button {
      display: inline-block;
      background: #00C853;
      color: white;
      padding: 1rem 2rem;
      text-decoration: none;
      border-radius: 5px;
      margin-top: 1rem;
    }

    /* Features Section */
    .features {
      padding: 4rem 1rem;
      background: #f9f9f9;
    }

    .features-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 2rem;
      max-width: 1200px;
      margin: 0 auto;
    }

    .feature-card {
      text-align: center;
      padding: 2rem;
      background: white;
      border-radius: 10px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    /* Footer */
    footer {
      background: #222;
      color: white;
      padding: 2rem 1rem;
      text-align: center;
    }
  </style>
</head>
<body>
  <header>
    <nav>
      <div class="logo">Justiz POS Pro</div>
      <div class="nav-links">
        <a href="#features">Features</a>
        <a href="#pricing">Pricing</a>
        <a href="#contact">Contact</a>
      </div>
    </nav>

    <div class="hero">
      <h1>Transform Your Business with Smart POS Solutions</h1>
      <p>Affordable, reliable, and easy-to-use POS systems for Kenyan businesses</p>
      <a href="#contact" class="cta-button">Get Started Today</a>
    </div>
  </header>

  <section class="features" id="features">
    <div class="features-grid">
      <div class="feature-card">
        <i class="fas fa-clock fa-3x"></i>
        <h3>24/7 Support</h3>
        <p>Round-the-clock customer service for your business needs</p>
      </div>
      <div class="feature-card">
        <i class="fas fa-chart-line fa-3x"></i>
        <h3>Sales Analytics</h3>
        <p>Real-time business insights and reporting</p>
      </div>
      <div class="feature-card">
        <i class="fas fa-shield-alt fa-3x"></i>
        <h3>Secure Payments</h3>
        <p>Bank-grade security for all transactions</p>
      </div>
    </div>
  </section>


<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Justiz POS Pro | Business Management System</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Arial', sans-serif;
    }

    body {
      line-height: 1.6;
      background: #f0f8ff;
    }

    header {
      background: #1e3799;
      color: white;
      padding: 2rem 1rem;
      text-align: center;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 2rem;
    }

    .section {
      background: white;
      border-radius: 10px;
      padding: 2rem;
      margin: 2rem 0;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    h1, h2, h3 {
      color: #1e3799;
      margin-bottom: 1rem;
    }

    .icon {
      font-size: 2rem;
      color: #1e3799;
      margin-bottom: 1rem;
    }

    .features-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 2rem;
      margin-top: 2rem;
    }

    .feature-card {
      padding: 1.5rem;
      border-left: 4px solid #1e3799;
      background: #f8f9ff;
    }

    ul {
      list-style: none;
      padding-left: 1rem;
    }

    li {
      margin: 0.5rem 0;
      position: relative;
      padding-left: 1.5rem;
    }

    li:before {
      content: "•";
      color: #1e3799;
      position: absolute;
      left: 0;
    }

    .cta-button {
      display: inline-block;
      background: #1e3799;
      color: white;
      padding: 1rem 2rem;
      text-decoration: none;
      border-radius: 5px;
      margin-top: 1rem;
    }

    footer {
      background: #1e3799;
      color: white;
      padding: 2rem;
      text-align: center;
    }
  </style>
</head>
<body>
  <header>
    <h1><i class="fas fa-cube"></i> Justiz POS Pro</h1>
    <p>Comprehensive Business Management Solution for Kenya</p>
  </header>

  <div class="container">
    <div class="section">
      <h2><i class="fas fa-star icon"></i>Why Choose Justiz POS Pro?</h2>
      <div class="features-grid">
        <div class="feature-card">
          <h3><i class="fas fa-expand-arrows-alt"></i> Scalability & Flexibility</h3>
          <ul>
            <li>Multi-business/location management</li>
            <li>Unlimited business capacity</li>
            <li>Storefront & warehouse support</li>
          </ul>
        </div>
        <div class="feature-card">
          <h3><i class="fas fa-shield-alt"></i> Security & Control</h3>
          <ul>
            <li>Role-based access control</li>
            <li>Custom user permissions</li>
            <li>Secure data segregation</li>
          </ul>
        </div>
      </div>
    </div>

    <div class="section">
      <h2><i class="fas fa-tools icon"></i>Core Features</h2>
      <div class="features-grid">
        <div class="feature-card">
          <h3><i class="fas fa-sitemap"></i> Multi-Business Management</h3>
          <ul>
            <li>Unlimited business units</li>
            <li>Independent inventory tracking</li>
            <li>Custom configurations</li>
          </ul>
        </div>
        <div class="feature-card">
          <h3><i class="fas fa-chart-line"></i> Advanced Reporting</h3>
          <ul>
            <li>Financial analytics</li>
            <li>Inventory trends</li>
            <li>Location performance</li>
          </ul>
        </div>
      </div>
    </div>

    <div class="section">
      <h2><i class="fas fa-cogs icon"></i>System Features</h2>
      <div class="features-grid">
        <div class="feature-card">
          <h3><i class="fas fa-users-cog"></i> User Management</h3>
          <ul>
            <li>Custom roles & permissions</li>
            <li>Unlimited user accounts</li>
            <li>Access control system</li>
          </ul>
        </div>
        <div class="feature-card">
          <h3><i class="fas fa-file-invoice-dollar"></i> Financial Tools</h3>
          <ul>
            <li>Automated payment reminders</li>
            <li>Multi-currency support</li>
            <li>Tax management</li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <footer>
    <p>Contact us: info@justizpospro.co.ke | +254 700 000 000</p>
    <p>© 2025 Justiz POS Pro. All Rights Reserved.</p>
  </footer>
</body>
</html>



<?php $__env->stopSection(); ?>
            
<?php echo $__env->make('layouts.auth2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loveandh/public_html/resources/views/welcome.blade.php ENDPATH**/ ?>