
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int NOT NULL,
  `type` enum('debit','credit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int NOT NULL,
  `transaction_id` int DEFAULT NULL,
  `transaction_payment_id` int DEFAULT NULL,
  `transfer_transaction_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int DEFAULT NULL,
  `business_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `account_type_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int DEFAULT NULL,
  `subject_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int DEFAULT NULL,
  `causer_id` int DEFAULT NULL,
  `causer_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-16 16:17:46','2024-09-16 16:17:46'),(2,'default','added',1,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2024-09-16 17:35:29','2024-09-16 17:35:29'),(3,'default','sell_deleted',1,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}',NULL,'2024-09-16 19:34:07','2024-09-16 19:34:07'),(4,'default','added',5,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2024-09-16 19:46:15','2024-09-16 19:46:19'),(5,'default','added',6,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":1450}}',NULL,'2024-09-16 19:55:39','2024-09-16 19:55:40'),(6,'default','edited',1,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-16 19:56:57','2024-09-16 19:56:57'),(7,'default','edited',6,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"1450.0000\"}}',NULL,'2024-09-16 19:58:40','2024-09-16 19:58:41'),(8,'default','added',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-16 20:00:50','2024-09-16 20:00:50'),(9,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-17 09:02:15','2024-09-17 09:02:15'),(10,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-17 09:25:55','2024-09-17 09:25:55'),(11,'default','added',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":220}}',NULL,'2024-09-17 09:26:27','2024-09-17 09:26:27'),(12,'default','added',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-17 09:46:00','2024-09-17 09:46:00'),(13,'default','added',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":250}}',NULL,'2024-09-17 09:46:17','2024-09-17 09:46:18'),(14,'default','added',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(15,'default','added',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2024-09-17 10:59:22','2024-09-17 10:59:22'),(16,'default','added',13,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2024-09-17 11:41:26','2024-09-17 11:41:26'),(17,'default','added',14,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2024-09-17 11:49:33','2024-09-17 11:49:33'),(18,'default','added',16,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(19,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2024-09-17 16:51:22','2024-09-17 16:51:23'),(20,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-17 17:28:21','2024-09-17 17:28:21'),(21,'default','added',21,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(22,'default','added',22,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-17 17:33:57','2024-09-17 17:33:57'),(23,'default','edited',1,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-18 07:56:09','2024-09-18 07:56:10'),(24,'default','added',23,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-18 11:40:46','2024-09-18 11:40:46'),(25,'default','added',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2024-09-18 17:01:01','2024-09-18 17:01:01'),(26,'default','added',25,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(27,'default','added',26,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2024-09-18 17:04:47','2024-09-18 17:04:47'),(28,'default','added',27,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-18 17:14:12','2024-09-18 17:14:12'),(29,'default','added',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(30,'default','added',34,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(31,'default','added',35,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-18 19:53:33','2024-09-18 19:53:33'),(32,'default','added',36,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2024-09-19 11:09:28','2024-09-19 11:09:28'),(33,'default','added',39,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2024-09-20 19:36:42','2024-09-20 19:36:42'),(34,'default','added',40,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2024-09-20 19:37:25','2024-09-20 19:37:25'),(35,'default','added',41,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2024-09-20 19:40:51','2024-09-20 19:40:52'),(36,'default','added',42,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-20 19:42:23','2024-09-20 19:42:23'),(37,'default','added',43,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(38,'default','added',44,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2024-09-23 13:53:32','2024-09-23 13:53:32'),(39,'default','added',47,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2024-09-23 14:21:21','2024-09-23 14:21:21'),(40,'default','added',48,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-23 14:24:47','2024-09-23 14:24:47'),(41,'default','added',49,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1570}}',NULL,'2024-09-23 17:49:01','2024-09-23 17:49:01'),(42,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-23 17:51:35','2024-09-23 17:51:35'),(43,'default','added',50,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2024-09-23 17:53:42','2024-09-23 17:53:42'),(44,'default','added',51,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-23 18:01:42','2024-09-23 18:01:42'),(45,'default','added',53,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(46,'default','added',54,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(47,'default','added',56,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(48,'default','added',57,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-09-24 16:11:05','2024-09-24 16:11:05'),(49,'default','added',58,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2024-09-27 08:15:10','2024-09-27 08:15:10'),(50,'default','added',59,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2024-09-27 08:17:58','2024-09-27 08:17:58'),(51,'default','sell_deleted',59,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":59,\"invoice_no\":\"0034\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1250.0000\"}}',NULL,'2024-09-27 08:19:39','2024-09-27 08:19:39'),(52,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-10 14:13:41','2024-10-10 14:13:41'),(53,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-10 14:13:56','2024-10-10 14:13:56'),(54,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-10 14:16:20','2024-10-10 14:16:20'),(55,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 08:46:45','2024-10-14 08:46:47'),(56,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 09:43:24','2024-10-14 09:43:24'),(57,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 09:50:52','2024-10-14 09:50:52'),(58,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 09:53:02','2024-10-14 09:53:02'),(59,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 09:53:05','2024-10-14 09:53:06'),(60,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 09:53:28','2024-10-14 09:53:28'),(61,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 09:53:41','2024-10-14 09:53:41'),(62,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 09:53:58','2024-10-14 09:53:58'),(63,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 09:53:59','2024-10-14 09:53:59'),(64,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 09:54:21','2024-10-14 09:54:21'),(65,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 11:21:11','2024-10-14 11:21:12'),(66,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 11:21:25','2024-10-14 11:21:25'),(67,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 11:38:01','2024-10-14 11:38:02'),(68,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 11:38:20','2024-10-14 11:38:20'),(69,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 11:46:50','2024-10-14 11:46:50'),(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 11:47:42','2024-10-14 11:47:42'),(71,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-14 11:48:10','2024-10-14 11:48:10'),(72,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-14 11:48:26','2024-10-14 11:48:26'),(73,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-15 21:04:32','2024-10-15 21:04:32'),(74,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-15 22:17:33','2024-10-15 22:17:34'),(75,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-15 22:18:41','2024-10-15 22:18:41'),(76,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-15 22:18:55','2024-10-15 22:18:56'),(77,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-15 22:45:43','2024-10-15 22:45:43'),(78,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-15 22:45:50','2024-10-15 22:45:50'),(79,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-16 16:40:14','2024-10-16 16:40:14'),(80,'default','added',60,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2024-10-16 16:42:25','2024-10-16 16:42:25'),(81,'default','added',61,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-10-16 16:44:24','2024-10-16 16:44:24'),(82,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-17 14:34:38','2024-10-17 14:34:38'),(83,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-17 15:48:22','2024-10-17 15:48:22'),(84,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-23 13:43:19','2024-10-23 13:43:19'),(85,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-25 10:47:47','2024-10-25 10:47:47'),(86,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-31 09:59:41','2024-10-31 09:59:41'),(87,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-08 21:00:20','2024-11-08 21:00:20'),(88,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-08 21:01:20','2024-11-08 21:01:20'),(89,'default','login',4,'App\\User',NULL,4,4,'App\\User','[]',NULL,'2024-11-20 21:20:43','2024-11-20 21:20:43'),(90,'default','logout',4,'App\\User',NULL,4,4,'App\\User','[]',NULL,'2024-11-20 21:29:34','2024-11-20 21:29:34'),(91,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-20 21:42:06','2024-11-20 21:42:06'),(92,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 19:55:36','2024-11-21 19:55:36'),(93,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:13:31','2024-11-21 20:13:31'),(94,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:13:43','2024-11-21 20:13:43'),(95,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:15:31','2024-11-21 20:15:31'),(96,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:15:36','2024-11-21 20:15:36'),(97,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:15:46','2024-11-21 20:15:47'),(98,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:15:54','2024-11-21 20:15:54'),(99,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:19:12','2024-11-21 20:19:12'),(100,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:19:20','2024-11-21 20:19:20'),(101,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:19:56','2024-11-21 20:19:56'),(102,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:20:03','2024-11-21 20:20:03'),(103,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:21:14','2024-11-21 20:21:14'),(104,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:21:22','2024-11-21 20:21:22'),(105,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:22:02','2024-11-21 20:22:02'),(106,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:22:09','2024-11-21 20:22:09'),(107,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:24:14','2024-11-21 20:24:14'),(108,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:24:27','2024-11-21 20:24:27'),(109,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:24:28','2024-11-21 20:24:28'),(110,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:24:35','2024-11-21 20:24:35'),(111,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:24:59','2024-11-21 20:24:59'),(112,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:25:14','2024-11-21 20:25:14'),(113,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:25:15','2024-11-21 20:25:15'),(114,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:25:24','2024-11-21 20:25:24'),(115,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:40:03','2024-11-21 20:40:04'),(116,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:40:13','2024-11-21 20:40:14'),(117,'default','logout',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:41:19','2024-11-21 20:41:19'),(118,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:41:28','2024-11-21 20:41:29'),(119,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-21 20:48:58','2024-11-21 20:48:58'),(120,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-21 20:49:11','2024-11-21 20:49:12'),(121,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-22 09:57:18','2024-11-22 09:57:18'),(122,'default','login',5,'App\\User',NULL,5,5,'App\\User','[]',NULL,'2024-11-23 10:43:35','2024-11-23 10:43:35'),(123,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 21:51:50','2024-11-23 21:51:50'),(124,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 21:59:34','2024-11-23 21:59:34'),(125,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:00:13','2024-11-23 22:00:13'),(126,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:04:33','2024-11-23 22:04:33'),(127,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:07:20','2024-11-23 22:07:20'),(128,'default','login',6,'App\\User',NULL,6,6,'App\\User','[]',NULL,'2024-11-23 22:08:11','2024-11-23 22:08:11'),(129,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:09:47','2024-11-23 22:09:47'),(130,'default','login',6,'App\\User',NULL,6,6,'App\\User','[]',NULL,'2024-11-23 22:09:59','2024-11-23 22:09:59'),(131,'default','logout',6,'App\\User',NULL,6,6,'App\\User','[]',NULL,'2024-11-23 22:16:53','2024-11-23 22:16:53'),(132,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:17:13','2024-11-23 22:17:13'),(133,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-23 22:17:58','2024-11-23 22:17:58'),(134,'default','login',6,'App\\User',NULL,6,6,'App\\User','[]',NULL,'2024-11-23 22:18:09','2024-11-23 22:18:09'),(135,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-28 17:03:12','2024-11-28 17:03:14');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int DEFAULT NULL,
  `business_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 03:13:44','2017-12-18 03:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 03:04:39','2017-12-18 03:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 02:55:40','2017-12-18 02:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 02:58:40','2017-12-18 02:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int unsigned NOT NULL,
  `waiter_id` int unsigned DEFAULT NULL,
  `table_id` int unsigned DEFAULT NULL,
  `correspondent_id` int DEFAULT NULL,
  `business_id` int unsigned NOT NULL,
  `location_id` int unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int unsigned NOT NULL,
  `booking_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int unsigned NOT NULL,
  `time_zone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pos_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `currency_precision` tinyint NOT NULL DEFAULT '2',
  `quantity_precision` tinyint NOT NULL DEFAULT '2',
  `ref_no_prefixes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sms_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_labels` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `common_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'JUSTIZ POS PRO',133,'2024-09-16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Africa/Nairobi',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"booking\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2024-09-16 18:47:15','2024-09-23 17:53:35'),(2,'Nakuru',133,'2024-10-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,2,'Africa/Nairobi',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-10-14 12:22:35','2024-10-14 12:22:35'),(4,'Test biz',133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,4,'Africa/Nairobi',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-11-20 23:50:00','2024-11-20 23:50:00'),(5,'JUSTIZ HARDWARE',133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,5,'Africa/Nairobi',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-11-21 00:11:17','2024-11-21 00:11:17'),(6,'mwanzo',133,'2024-11-23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,6,'Africa/Nairobi',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `business_locations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `location_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int unsigned NOT NULL,
  `sale_invoice_scheme_id` int DEFAULT NULL,
  `invoice_layout_id` int unsigned NOT NULL,
  `sale_invoice_layout_id` int DEFAULT NULL,
  `selling_price_group_id` int DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','JUSTIZ POS PRO','BURUBURU','Kenya','rift valley','nakuru','12951',1,NULL,1,1,NULL,1,'browser',NULL,'0768225168','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(2,1,'BL0002','JUSTIZ LAUNDRY BURUBURU','BURUBURU','Kenya','rift valley','nakuru','12951',1,1,1,1,0,1,'browser',NULL,NULL,NULL,'ptakalei@gmail.com',NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2024-09-16 19:49:15','2024-09-16 19:49:15'),(3,2,'BL0001','Nakuru','admin','Kenya','rift valley','nakuru','12951',2,NULL,2,2,NULL,1,'browser',NULL,'070000000','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(4,4,'BL0001','Test biz','Highway towers 12th floor rm 6','kenya','nakuru','nakur','20100',4,NULL,4,4,NULL,1,'browser',NULL,'070000000','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2024-11-20 23:50:08','2024-11-20 23:50:08'),(5,5,'BL0001','JUSTIZ HARDWARE','HIGHWAY TOWERS 12TH FLOOR','KENYA','NAKURU','NAKURU','20100',5,NULL,5,5,NULL,1,'browser',NULL,'07000000/012222222','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2024-11-21 00:11:28','2024-11-21 00:11:28'),(6,6,'BL0001','mwanzo','peter','Kenya','rift valley','nakuru','12951',6,NULL,6,6,NULL,1,'browser',NULL,'070000000','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_denominations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_register_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (2,1,1150.0000,'cash','credit','sell',5,'2024-09-16 19:46:04','2024-09-16 19:46:04'),(3,1,1000.0000,'cash','credit','sell',6,'2024-09-16 19:58:36','2024-09-16 19:58:36'),(4,1,1000.0000,'cash','debit','expense',7,'2024-09-16 20:00:50','2024-09-16 20:00:50'),(5,1,200.0000,'cash','credit','sell',9,'2024-09-17 09:46:17','2024-09-17 09:46:17'),(6,1,350.0000,'custom_pay_1','credit','sell',11,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(7,1,50.0000,'cash','credit','sell',12,'2024-09-17 10:59:19','2024-09-17 10:59:19'),(8,1,300.0000,'cash','credit','sell',13,'2024-09-17 11:41:25','2024-09-17 11:41:25'),(9,1,50.0000,'cash','credit','sell',14,'2024-09-17 11:49:33','2024-09-17 11:49:33'),(10,1,150.0000,'cash','credit','sell',16,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(11,1,450.0000,'cash','credit','sell',18,'2024-09-17 16:51:21','2024-09-17 16:51:21'),(12,1,150.0000,'cash','credit','sell',19,'2024-09-17 17:28:21','2024-09-17 17:28:21'),(13,1,150.0000,'cash','credit','sell',21,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(14,1,150.0000,'custom_pay_1','credit','sell',23,'2024-09-18 11:40:41','2024-09-18 11:40:41'),(15,1,1300.0000,'cash','credit','sell',24,'2024-09-18 17:01:01','2024-09-18 17:01:01'),(16,1,500.0000,'cash','credit','sell',25,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(17,1,350.0000,'custom_pay_1','credit','sell',26,'2024-09-18 17:04:47','2024-09-18 17:04:47'),(18,1,100.0000,'cash','credit','sell',29,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(19,1,200.0000,'cash','credit','sell',34,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(20,1,120.0000,'cash','credit','sell',36,'2024-09-19 11:09:24','2024-09-19 11:09:24'),(21,1,600.0000,'cash','credit','sell',39,'2024-09-20 19:36:42','2024-09-20 19:36:42'),(22,1,300.0000,'cash','credit','sell',40,'2024-09-20 19:37:24','2024-09-20 19:37:24'),(23,1,250.0000,'cash','credit','sell',41,'2024-09-20 19:40:51','2024-09-20 19:40:51'),(24,1,150.0000,'cash','credit','sell',42,'2024-09-20 19:42:23','2024-09-20 19:42:23'),(25,1,250.0000,'cash','credit','sell',43,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(26,1,450.0000,'cash','credit','sell',44,'2024-09-23 13:53:32','2024-09-23 13:53:32'),(27,1,650.0000,'cash','credit','sell',47,'2024-09-23 14:21:20','2024-09-23 14:21:20'),(28,1,150.0000,'cash','credit','sell',48,'2024-09-23 14:24:47','2024-09-23 14:24:47'),(29,1,1570.0000,'cash','credit','sell',49,'2024-09-23 17:49:00','2024-09-23 17:49:00'),(30,1,550.0000,'cash','credit','sell',53,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(31,1,150.0000,'cash','credit','sell',54,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(32,1,100.0000,'cash','credit','sell',56,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(33,2,1000.0000,'cash','credit','sell',60,'2024-10-16 16:42:25','2024-10-16 16:42:25');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_registers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `location_id` int DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `status` enum('close','open') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int NOT NULL DEFAULT '0',
  `total_cheques` int NOT NULL DEFAULT '0',
  `denominations` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `closing_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2024-09-16 16:32:00','2024-09-16 16:32:19'),(2,2,3,2,'open',NULL,0.0000,0,0,NULL,NULL,'2024-10-16 16:41:00','2024-10-16 16:41:54');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int unsigned NOT NULL,
  `short_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int NOT NULL,
  `created_by` int unsigned NOT NULL,
  `category_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `category_id` int NOT NULL,
  `categorizable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_business_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `address_line_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int DEFAULT NULL,
  `pay_term_type` enum('days','months') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `shipping_custom_field_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_field_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_5` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_6` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int DEFAULT NULL,
  `custom_field1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer','individual',NULL,'Walk in customer',NULL,'Walk in customer',NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'787878787',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 18:47:15','2024-09-18 07:56:09'),(2,1,'customer','individual',NULL,'mama g532',NULL,'mama g532',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'07000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 09:25:55','2024-09-17 09:25:55'),(3,1,'customer','individual',NULL,'Thomas',NULL,'Thomas',NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'07000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 09:46:00','2024-09-17 09:46:00'),(4,1,'supplier','individual',NULL,'Jayjay',NULL,'Jayjay',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0700000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 17:51:35','2024-09-23 17:51:35'),(5,2,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,2,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(7,4,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,4,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-20 23:50:03','2024-11-20 23:50:03'),(8,5,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,5,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(9,6,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,6,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int DEFAULT NULL,
  `created_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_configurations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `created_by` int NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_variations` (
  `discount_id` int NOT NULL,
  `variation_id` int NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int NOT NULL,
  `brand_id` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `discount_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `spg` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_and_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `notable_id` int NOT NULL,
  `notable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int unsigned NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int unsigned NOT NULL,
  `tax_id` int unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_layouts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commission_agent_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT '0',
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `module_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `common_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT '0',
  `letter_head` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `qr_code_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `design` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,1,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-09-16 18:47:15','2024-09-16 18:47:15'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,2,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,4,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-11-20 23:50:04','2024-11-20 23:50:04'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,5,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(6,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,6,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_schemes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `number_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int DEFAULT NULL,
  `invoice_count` int NOT NULL DEFAULT '0',
  `total_digits` int DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,34,4,1,'2024-09-16 18:47:15','2024-09-27 08:17:47'),(2,2,'Default','blank','sequential','',1,1,4,1,'2024-10-14 12:22:38','2024-10-16 16:42:24'),(4,4,'Default','blank','sequential','',1,0,4,1,'2024-11-20 23:50:04','2024-11-20 23:50:04'),(5,5,'Default','blank','sequential','',1,0,4,1,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(6,6,'Default','blank','sequential','',1,0,4,1,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `file_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int DEFAULT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=301 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(296,'2023_12_06_152840_add_contact_type_in_contacts',1),(297,'2018_06_27_185405_create_packages_table',2),(298,'2018_06_28_182803_create_subscriptions_table',2),(299,'2018_07_17_182021_add_rows_to_system_table',2),(300,'2018_07_19_131721_add_options_to_packages_table',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` int unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(7,'App\\User',4),(9,'App\\User',5),(12,'App\\User',6);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `template_for` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sms_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-16 18:47:16','2024-09-16 18:47:16'),(11,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(12,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(13,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(14,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(15,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(16,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(17,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(18,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(19,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(20,2,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(27,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:05','2024-11-20 23:50:05'),(28,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:05','2024-11-20 23:50:05'),(29,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:05','2024-11-20 23:50:05'),(30,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(31,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(32,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(33,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(34,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(35,4,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(36,4,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-20 23:50:06','2024-11-20 23:50:06'),(37,5,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(38,5,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(39,5,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:25','2024-11-21 00:11:25'),(40,5,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:25','2024-11-21 00:11:25'),(41,5,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:25','2024-11-21 00:11:25'),(42,5,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:26','2024-11-21 00:11:26'),(43,5,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:27','2024-11-21 00:11:27'),(44,5,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:27','2024-11-21 00:11:27'),(45,5,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:28','2024-11-21 00:11:28'),(46,5,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-21 00:11:28','2024-11-21 00:11:28'),(47,6,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(48,6,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(49,6,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(50,6,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(51,6,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(52,6,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(53,6,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(54,6,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(55,6,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(56,6,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL,
  `client_id` int unsigned NOT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int NOT NULL,
  `product_count` int NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable tables',
  `invoice_count` int NOT NULL,
  `interval` enum('days','months','years') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int NOT NULL,
  `trial_days` int NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `created_by` int NOT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'BRONZE','Run your business effectively',1,0,0,0,0,0,0,0,'months',1,14,10.0000,1,1,1,NULL,'2024-10-14 12:20:38','2024-11-24 00:39:27'),(2,'Silver Double Biz','Combine operation of your Branches in one Dashboard',3,0,0,0,0,0,0,0,'months',1,14,1499.0000,1,1,1,NULL,'2024-10-31 12:34:26','2024-10-31 12:42:07'),(3,'One Time Package','Pay Once and Run Your Business Effectively',6,0,0,0,0,0,0,0,'months',1,14,24499.0000,1,1,1,NULL,'2024-10-31 12:36:46','2024-10-31 12:36:46');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2024-09-16 17:57:25',NULL),(2,'direct_sell.access','web','2024-09-16 17:57:25',NULL),(3,'product.opening_stock','web','2024-09-16 17:57:26','2024-09-16 17:57:26'),(4,'crud_all_bookings','web','2024-09-16 17:57:27','2024-09-16 17:57:27'),(5,'crud_own_bookings','web','2024-09-16 17:57:27','2024-09-16 17:57:27'),(6,'access_default_selling_price','web','2024-09-16 17:57:27','2024-09-16 17:57:27'),(7,'purchase.payments','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(8,'sell.payments','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(9,'edit_product_price_from_sale_screen','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(10,'edit_product_discount_from_sale_screen','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(11,'roles.view','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(12,'roles.create','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(13,'roles.update','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(14,'roles.delete','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(15,'account.access','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(16,'discount.access','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(17,'view_purchase_price','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(18,'view_own_sell_only','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(19,'edit_product_discount_from_pos_screen','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(20,'edit_product_price_from_pos_screen','web','2024-09-16 17:57:28','2024-09-16 17:57:28'),(21,'access_shipping','web','2024-09-16 17:57:29','2024-09-16 17:57:29'),(22,'purchase.update_status','web','2024-09-16 17:57:29','2024-09-16 17:57:29'),(23,'list_drafts','web','2024-09-16 17:57:29','2024-09-16 17:57:29'),(24,'list_quotations','web','2024-09-16 17:57:29','2024-09-16 17:57:29'),(25,'view_cash_register','web','2024-09-16 17:57:32','2024-09-16 17:57:32'),(26,'close_cash_register','web','2024-09-16 17:57:32','2024-09-16 17:57:32'),(27,'print_invoice','web','2024-09-16 17:57:33','2024-09-16 17:57:33'),(28,'user.view','web','2024-09-16 17:57:35',NULL),(29,'user.create','web','2024-09-16 17:57:35',NULL),(30,'user.update','web','2024-09-16 17:57:35',NULL),(31,'user.delete','web','2024-09-16 17:57:35',NULL),(32,'supplier.view','web','2024-09-16 17:57:35',NULL),(33,'supplier.create','web','2024-09-16 17:57:35',NULL),(34,'supplier.update','web','2024-09-16 17:57:35',NULL),(35,'supplier.delete','web','2024-09-16 17:57:35',NULL),(36,'customer.view','web','2024-09-16 17:57:35',NULL),(37,'customer.create','web','2024-09-16 17:57:35',NULL),(38,'customer.update','web','2024-09-16 17:57:35',NULL),(39,'customer.delete','web','2024-09-16 17:57:35',NULL),(40,'product.view','web','2024-09-16 17:57:35',NULL),(41,'product.create','web','2024-09-16 17:57:35',NULL),(42,'product.update','web','2024-09-16 17:57:35',NULL),(43,'product.delete','web','2024-09-16 17:57:35',NULL),(44,'purchase.view','web','2024-09-16 17:57:35',NULL),(45,'purchase.create','web','2024-09-16 17:57:35',NULL),(46,'purchase.update','web','2024-09-16 17:57:35',NULL),(47,'purchase.delete','web','2024-09-16 17:57:35',NULL),(48,'sell.view','web','2024-09-16 17:57:35',NULL),(49,'sell.create','web','2024-09-16 17:57:35',NULL),(50,'sell.update','web','2024-09-16 17:57:35',NULL),(51,'sell.delete','web','2024-09-16 17:57:35',NULL),(52,'purchase_n_sell_report.view','web','2024-09-16 17:57:35',NULL),(53,'contacts_report.view','web','2024-09-16 17:57:35',NULL),(54,'stock_report.view','web','2024-09-16 17:57:35',NULL),(55,'tax_report.view','web','2024-09-16 17:57:35',NULL),(56,'trending_product_report.view','web','2024-09-16 17:57:35',NULL),(57,'register_report.view','web','2024-09-16 17:57:35',NULL),(58,'sales_representative.view','web','2024-09-16 17:57:35',NULL),(59,'expense_report.view','web','2024-09-16 17:57:35',NULL),(60,'business_settings.access','web','2024-09-16 17:57:35',NULL),(61,'barcode_settings.access','web','2024-09-16 17:57:35',NULL),(62,'invoice_settings.access','web','2024-09-16 17:57:35',NULL),(63,'brand.view','web','2024-09-16 17:57:35',NULL),(64,'brand.create','web','2024-09-16 17:57:35',NULL),(65,'brand.update','web','2024-09-16 17:57:35',NULL),(66,'brand.delete','web','2024-09-16 17:57:35',NULL),(67,'tax_rate.view','web','2024-09-16 17:57:35',NULL),(68,'tax_rate.create','web','2024-09-16 17:57:35',NULL),(69,'tax_rate.update','web','2024-09-16 17:57:35',NULL),(70,'tax_rate.delete','web','2024-09-16 17:57:35',NULL),(71,'unit.view','web','2024-09-16 17:57:35',NULL),(72,'unit.create','web','2024-09-16 17:57:35',NULL),(73,'unit.update','web','2024-09-16 17:57:35',NULL),(74,'unit.delete','web','2024-09-16 17:57:35',NULL),(75,'category.view','web','2024-09-16 17:57:35',NULL),(76,'category.create','web','2024-09-16 17:57:35',NULL),(77,'category.update','web','2024-09-16 17:57:35',NULL),(78,'category.delete','web','2024-09-16 17:57:35',NULL),(79,'expense.access','web','2024-09-16 17:57:35',NULL),(80,'access_all_locations','web','2024-09-16 17:57:35',NULL),(81,'dashboard.data','web','2024-09-16 17:57:35',NULL),(82,'location.1','web','2024-09-16 18:47:16','2024-09-16 18:47:16'),(83,'location.2','web','2024-09-16 19:49:19','2024-09-16 19:49:19'),(84,'location.3','web','2024-10-14 12:22:40','2024-10-14 12:22:40'),(85,'location.4','web','2024-11-20 23:50:11','2024-11-20 23:50:11'),(86,'location.5','web','2024-11-21 00:11:28','2024-11-21 00:11:28'),(87,'view_export_buttons','web','2024-11-21 20:01:39','2024-11-21 20:01:39'),(88,'location.6','web','2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `printers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_locations` (
  `product_id` int NOT NULL,
  `location_id` int NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(133,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(258,1),(259,1),(260,1),(261,1),(262,1),(263,1),(264,1),(265,1),(266,1),(48,2),(77,2),(78,2),(79,2),(80,2),(93,2),(267,1),(268,1),(269,3);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_racks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `location_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `rack` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_variations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(2,NULL,'DUMMY',2,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(3,NULL,'DUMMY',3,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(4,NULL,'DUMMY',4,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(5,NULL,'DUMMY',5,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(6,NULL,'DUMMY',6,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(7,NULL,'DUMMY',7,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(8,NULL,'DUMMY',8,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(9,NULL,'DUMMY',9,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(10,NULL,'DUMMY',10,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(11,NULL,'DUMMY',11,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(12,NULL,'DUMMY',12,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(13,NULL,'DUMMY',13,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(14,NULL,'DUMMY',14,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(15,NULL,'DUMMY',15,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(16,NULL,'DUMMY',16,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(17,NULL,'DUMMY',17,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(18,NULL,'DUMMY',18,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(19,NULL,'DUMMY',19,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(20,NULL,'DUMMY',20,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(21,NULL,'DUMMY',21,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(22,NULL,'DUMMY',22,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(23,NULL,'DUMMY',23,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(24,NULL,'DUMMY',24,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(25,NULL,'DUMMY',25,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(26,NULL,'DUMMY',26,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(27,NULL,'DUMMY',27,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(28,NULL,'DUMMY',28,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(29,NULL,'DUMMY',29,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(30,NULL,'DUMMY',30,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(31,NULL,'DUMMY',31,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(32,NULL,'DUMMY',32,1,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(33,NULL,'DUMMY',33,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(34,NULL,'DUMMY',34,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(35,NULL,'DUMMY',35,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(36,NULL,'DUMMY',36,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(37,NULL,'DUMMY',37,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(38,NULL,'DUMMY',38,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(39,NULL,'DUMMY',39,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(40,NULL,'DUMMY',40,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(41,NULL,'DUMMY',41,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(42,NULL,'DUMMY',42,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(43,NULL,'DUMMY',43,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(44,NULL,'DUMMY',44,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(45,NULL,'DUMMY',45,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(46,NULL,'DUMMY',46,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(47,NULL,'DUMMY',47,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(48,NULL,'DUMMY',48,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(49,NULL,'DUMMY',49,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(50,NULL,'DUMMY',50,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(51,NULL,'DUMMY',51,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(52,NULL,'DUMMY',52,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(53,NULL,'DUMMY',53,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(54,NULL,'DUMMY',54,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(55,NULL,'DUMMY',55,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(56,NULL,'DUMMY',56,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(57,NULL,'DUMMY',57,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(58,NULL,'DUMMY',58,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(59,NULL,'DUMMY',59,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(60,NULL,'DUMMY',60,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(61,NULL,'DUMMY',61,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(62,NULL,'DUMMY',62,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(63,NULL,'DUMMY',63,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(64,NULL,'DUMMY',64,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(65,NULL,'DUMMY',65,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(66,NULL,'DUMMY',66,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(67,NULL,'DUMMY',67,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(68,NULL,'DUMMY',68,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(69,NULL,'DUMMY',69,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(70,NULL,'DUMMY',70,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(71,NULL,'DUMMY',71,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(72,NULL,'DUMMY',72,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(73,NULL,'DUMMY',73,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(74,NULL,'DUMMY',74,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(75,NULL,'DUMMY',75,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(76,NULL,'DUMMY',76,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(77,NULL,'DUMMY',77,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(78,NULL,'DUMMY',78,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(79,NULL,'DUMMY',79,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(80,NULL,'DUMMY',80,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(81,NULL,'DUMMY',81,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(82,NULL,'DUMMY',82,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(83,NULL,'DUMMY',83,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(84,NULL,'DUMMY',84,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(85,NULL,'DUMMY',85,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(86,NULL,'DUMMY',86,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(87,NULL,'DUMMY',87,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(88,NULL,'DUMMY',88,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(89,NULL,'DUMMY',89,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(90,NULL,'DUMMY',90,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(91,NULL,'DUMMY',91,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(92,NULL,'DUMMY',92,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(93,NULL,'DUMMY',93,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(94,NULL,'DUMMY',94,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(95,NULL,'DUMMY',95,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(96,NULL,'DUMMY',96,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(97,NULL,'DUMMY',97,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(98,NULL,'DUMMY',98,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(99,NULL,'DUMMY',99,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(100,NULL,'DUMMY',100,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(101,NULL,'DUMMY',101,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(102,NULL,'DUMMY',102,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(103,NULL,'DUMMY',103,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(104,NULL,'DUMMY',104,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(105,NULL,'DUMMY',105,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(106,NULL,'DUMMY',106,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(107,NULL,'DUMMY',107,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(108,NULL,'DUMMY',108,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(109,NULL,'DUMMY',109,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(110,NULL,'DUMMY',110,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(111,NULL,'DUMMY',111,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(112,NULL,'DUMMY',112,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(113,NULL,'DUMMY',113,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(114,NULL,'DUMMY',114,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(115,NULL,'DUMMY',115,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(116,NULL,'DUMMY',116,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(117,NULL,'DUMMY',117,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(118,NULL,'DUMMY',118,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(119,NULL,'DUMMY',119,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(120,NULL,'DUMMY',120,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(121,NULL,'DUMMY',121,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(122,NULL,'DUMMY',122,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(123,NULL,'DUMMY',123,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(124,NULL,'DUMMY',124,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(125,NULL,'DUMMY',125,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(126,NULL,'DUMMY',126,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(127,NULL,'DUMMY',127,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(128,NULL,'DUMMY',128,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(129,NULL,'DUMMY',129,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(130,NULL,'DUMMY',130,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(131,NULL,'DUMMY',131,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(132,NULL,'DUMMY',132,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(133,NULL,'DUMMY',133,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(134,NULL,'DUMMY',134,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(135,NULL,'DUMMY',135,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(136,NULL,'DUMMY',136,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(137,NULL,'DUMMY',137,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(138,NULL,'DUMMY',138,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(139,NULL,'DUMMY',139,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(140,NULL,'DUMMY',140,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(141,NULL,'DUMMY',141,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(142,NULL,'DUMMY',142,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(143,NULL,'DUMMY',143,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(144,NULL,'DUMMY',144,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(145,NULL,'DUMMY',145,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(146,NULL,'DUMMY',146,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(147,NULL,'DUMMY',147,1,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(148,NULL,'DUMMY',148,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(149,NULL,'DUMMY',149,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(150,NULL,'DUMMY',150,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(151,NULL,'DUMMY',151,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(152,NULL,'DUMMY',152,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(153,NULL,'DUMMY',153,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(154,NULL,'DUMMY',154,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(155,NULL,'DUMMY',155,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(156,NULL,'DUMMY',156,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(157,NULL,'DUMMY',157,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(158,NULL,'DUMMY',158,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(159,NULL,'DUMMY',159,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(160,NULL,'DUMMY',160,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(161,NULL,'DUMMY',161,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(162,NULL,'DUMMY',162,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(163,NULL,'DUMMY',163,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(164,NULL,'DUMMY',164,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(165,NULL,'DUMMY',165,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(166,NULL,'DUMMY',166,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(167,NULL,'DUMMY',167,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(168,NULL,'DUMMY',168,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(169,NULL,'DUMMY',169,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(170,NULL,'DUMMY',170,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(171,NULL,'DUMMY',171,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(172,NULL,'DUMMY',172,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(173,NULL,'DUMMY',173,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(174,NULL,'DUMMY',174,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(175,NULL,'DUMMY',175,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(176,NULL,'DUMMY',176,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(177,NULL,'DUMMY',177,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(178,NULL,'DUMMY',178,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(179,NULL,'DUMMY',179,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(180,NULL,'DUMMY',180,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(181,NULL,'DUMMY',181,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(182,NULL,'DUMMY',182,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(183,NULL,'DUMMY',183,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(184,NULL,'DUMMY',184,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(185,NULL,'DUMMY',185,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(186,NULL,'DUMMY',186,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(187,NULL,'DUMMY',187,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(188,NULL,'DUMMY',188,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(189,NULL,'DUMMY',189,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(190,NULL,'DUMMY',190,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(191,NULL,'DUMMY',191,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(192,NULL,'DUMMY',192,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(193,NULL,'DUMMY',193,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(194,NULL,'DUMMY',194,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(195,NULL,'DUMMY',195,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(196,NULL,'DUMMY',196,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(197,NULL,'DUMMY',197,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(198,NULL,'DUMMY',198,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(199,NULL,'DUMMY',199,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(200,NULL,'DUMMY',200,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(201,NULL,'DUMMY',201,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(202,NULL,'DUMMY',202,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(203,NULL,'DUMMY',203,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(204,NULL,'DUMMY',204,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(205,NULL,'DUMMY',205,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(206,NULL,'DUMMY',206,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(207,NULL,'DUMMY',207,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(208,NULL,'DUMMY',208,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(209,NULL,'DUMMY',209,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(210,NULL,'DUMMY',210,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(211,NULL,'DUMMY',211,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(212,NULL,'DUMMY',212,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(213,NULL,'DUMMY',213,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(214,NULL,'DUMMY',214,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(215,NULL,'DUMMY',215,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(216,NULL,'DUMMY',216,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(217,NULL,'DUMMY',217,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(218,NULL,'DUMMY',218,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(219,NULL,'DUMMY',219,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(220,NULL,'DUMMY',220,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(221,NULL,'DUMMY',221,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(222,NULL,'DUMMY',222,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(223,NULL,'DUMMY',223,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(224,NULL,'DUMMY',224,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(225,NULL,'DUMMY',225,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(226,NULL,'DUMMY',226,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(227,NULL,'DUMMY',227,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(228,NULL,'DUMMY',228,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(229,NULL,'DUMMY',229,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(230,NULL,'DUMMY',230,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(231,NULL,'DUMMY',231,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(232,NULL,'DUMMY',232,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(233,NULL,'DUMMY',233,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(234,NULL,'DUMMY',234,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(235,NULL,'DUMMY',235,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(236,NULL,'DUMMY',236,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(237,NULL,'DUMMY',237,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(238,NULL,'DUMMY',238,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(239,NULL,'DUMMY',239,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(240,NULL,'DUMMY',240,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(241,NULL,'DUMMY',241,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(242,NULL,'DUMMY',242,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(243,NULL,'DUMMY',243,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(244,NULL,'DUMMY',244,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(245,NULL,'DUMMY',245,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(246,NULL,'DUMMY',246,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(247,NULL,'DUMMY',247,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(248,NULL,'DUMMY',248,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(249,NULL,'DUMMY',249,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(250,NULL,'DUMMY',250,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(251,NULL,'DUMMY',251,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(252,NULL,'DUMMY',252,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(253,NULL,'DUMMY',253,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(254,NULL,'DUMMY',254,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(255,NULL,'DUMMY',255,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(256,NULL,'DUMMY',256,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(257,NULL,'DUMMY',257,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(258,NULL,'DUMMY',258,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(259,NULL,'DUMMY',259,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(260,NULL,'DUMMY',260,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(261,NULL,'DUMMY',261,1,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(262,NULL,'DUMMY',262,1,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(263,NULL,'DUMMY',263,1,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(264,NULL,'DUMMY',264,1,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(265,NULL,'DUMMY',265,1,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(266,NULL,'DUMMY',266,1,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(267,NULL,'DUMMY',267,1,'2024-09-17 10:17:38','2024-09-17 10:17:38'),(268,NULL,'DUMMY',268,1,'2024-09-18 19:48:54','2024-09-18 19:48:54'),(269,NULL,'DUMMY',269,1,'2024-10-16 16:41:10','2024-10-16 16:41:10');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int unsigned DEFAULT NULL,
  `secondary_unit_id` int DEFAULT NULL,
  `sub_unit_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `brand_id` int unsigned DEFAULT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `sub_category_id` int unsigned DEFAULT NULL,
  `tax` int unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field5` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field6` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field7` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field8` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field9` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field10` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field11` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field12` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field13` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field14` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field15` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field16` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field17` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field18` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field19` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field20` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int unsigned NOT NULL,
  `preparation_time_in_minutes` int DEFAULT NULL,
  `warranty_id` int DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'016 extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(2,'017 extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(3,'018 extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(4,'1 by 1 jackpin',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(5,'1 by1 ox cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(6,'16gb flash',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(7,'16gb mem',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(8,'2 by 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(9,'2 by one jackpin',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(10,'3 by 1 jackpin',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(11,'3 by 3  wire',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(12,'3/3 jack pin',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(13,'32gb flash',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(14,'32gb mem',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(15,'3G charger',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(16,'4gb flash',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(17,'4gb mem',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(18,'5D screen guard',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(19,'5m tape measure',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(20,'8gb flash',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(21,'8gb mem',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(22,'AAA 1.5V battery',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(23,'Aerial',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(24,'Aerial jackpin',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(25,'Aerial jackpin plastic',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(26,'All in one set',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0026','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(27,'Amaya 2A sachet cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0027','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-17 13:28:09'),(28,'Amaya cable type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0028','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-17 16:49:36'),(29,'Amaya cable plain box',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0029','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(30,'Amaya charger 250 orange',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(31,'Amaya green charger',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0031','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 19:42:41'),(32,'Amaya small package cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0032','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:49'),(33,'Amaya Super cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:49','2024-09-16 17:32:50'),(34,'Angle bulb holder  small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(35,'Angle bulb holder big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0035','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(36,'Ankle socks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0036','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(37,'Astra extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(38,'Auddy padlock',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(39,'Avc 10 waats',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0039','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 19:39:23'),(40,'Avc 15 waats',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(41,'Avc 5waats bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(42,'Baby shakers',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0042','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(43,'Ball',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0043','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(44,'Bedswitch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(45,'bedswitch with extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(46,'Belt',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(47,'bic  one',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0047','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(48,'Big basket',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0048','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(49,'Big tester',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0049','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(50,'Big washing brush',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(51,'Black extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(52,'Black heater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(53,'Black tape',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0053','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(54,'Black tape sunap',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0054','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(55,'Black top plug',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(56,'Bluetooth Earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0056','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(57,'Box earphone abj Tecno amaya',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0057','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(58,'bulb avc 10w',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(59,'Bulb holder big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0059','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(60,'Burner 13kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(61,'Cable clips',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(62,'Calculator watch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0062','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(63,'Camel set',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(64,'Caston extensions',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0064','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-19 13:51:56'),(65,'charger 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(66,'Charger head',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0066','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(67,'clear tape',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0067','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(68,'Color bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(69,'Complete suit',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0069','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(70,'Cord',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(71,'Domain Registration',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(72,'Double socket',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(73,'Double switch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0073','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(74,'Downy @20',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0074','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(75,'Dp light 40waats bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(76,'Dr Lee earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0076','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-24 09:52:18'),(77,'Duvet 3*6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0077','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(78,'Duvet 4*6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(79,'Duvet 5*6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(80,'Duvet 6*6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(81,'Earpods',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(82,'Editing',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(83,'Excellent universal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(84,'Face towel',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(85,'flex green wire',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(86,'Flex wire blue',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0086','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(87,'Flex wire red',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0087','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(88,'Floating ark type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(89,'Flower cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(90,'Fore padlock',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(91,'Fork',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(92,'Fruit knife',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(93,'General laundry',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(94,'General laundry',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0094','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(95,'Globe tape',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(96,'Go tv adapter',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0096','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(97,'grate',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(98,'Green heater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(99,'Hair dye',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0099','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(100,'Hanging bulb holder',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(101,'Hard circle 263',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(102,'Hard circle 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(103,'Hard circle 265',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(104,'Hb pencils',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(105,'HDMI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(106,'Hoyan 3.1 cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(107,'Hoyan 6.0 cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(108,'Hoyan bluetooth',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(109,'Hoyan cable 2.1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(110,'Hoyan chargers',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(111,'Hoyan Type C cable box',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(112,'HR gas burner',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(113,'I.5 wire',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(114,'I12 earpods',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(115,'I12 earpods',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(116,'Infinix box earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(117,'insulating tape big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0117','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(118,'insulating tape small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(119,'Iphone cable box',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(120,'Iphone cable sachet',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(121,'Ironing',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(122,'Itel 10waats charger',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(123,'itel 5A',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0123','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(124,'Itel battery normal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0124','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-23 14:17:05'),(125,'Itel battery original',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(126,'Itel C21 type c cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0126','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(127,'Itel c22 tpe c cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(128,'Itel c32  type c cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(129,'Itel charger type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(130,'Itel earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(131,'Itel M11 cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0131','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-18 19:47:13'),(132,'Jackets',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(133,'Jamax  smart life earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0133','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(134,'Jeans trouser',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0134','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(135,'Jumpers',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(136,'Kettle',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(137,'Key chain',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(138,'Khaki mouse',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(139,'Kids watch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(140,'Kids watch stylish',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(141,'Kim charger',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(142,'Kiwi knives',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(143,'L8 radio',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0143','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(144,'Laptop adapter',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(145,'Large grater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0145','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(146,'Lcd universal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(147,'Lite gas burner',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:50','2024-09-16 17:32:50'),(148,'Machine oil',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(149,'Material/khaki trousers',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(150,'Measuring tape 7.5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(151,'Medium grater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(152,'Mem reader',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(153,'Men Watch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(154,'Multi cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(155,'Nakuru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(156,'nap cards',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(157,'Neelux bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(158,'New communicative earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(159,'normal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(160,'Normal screen guard',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(161,'O.T.G type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(162,'Ofia box earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(163,'Ofia earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0163','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-24 16:07:44'),(164,'opener big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0164','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(165,'Optical mouse',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(166,'Oraimo battery normal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0166','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-17 17:31:18'),(167,'Oraimo cable paper',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0167','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 19:41:13'),(168,'Oraimo charger original',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(169,'Oraimo charger type 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(170,'Oraimo charger type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(171,'Oraimo original battery',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(172,'Oraimo paper earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(173,'Oraimo paper type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(174,'Oraimo type c cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(175,'orgas burner',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(176,'Osram bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(177,'Otg normal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0177','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-18 19:50:41'),(178,'Otg type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0178','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-18 19:51:39'),(179,'Oxford set',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(180,'P47 headphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(181,'Passport',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(182,'Pec bulb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(183,'Phone cover',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(184,'Photo printing',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0184','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(185,'Photocopy',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(186,'Pk extension',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0186','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-19 13:53:34'),(187,'Ppm earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(188,'Prime single socket',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(189,'Primus gas burner',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(190,'Printing',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(191,'Punex earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(192,'Radio battery',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0192','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(193,'Real me box earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(194,'Real me buds earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(195,'real me earphone box',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0195','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(196,'Real me earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0196','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(197,'Red flex wire 10 per metre',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0197','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(198,'Red heater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0198','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(199,'REGULATOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0199','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(200,'REPAIR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(201,'RXD earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(202,'Samsung Bluetooth',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(203,'Samsung HS330',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(204,'Samsung S7 earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(205,'Samsung SMA earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(206,'Samsung sport pace earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(207,'Scissors',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(208,'Serving spoons',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(209,'Shorts',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0209','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(210,'Single patrice',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(211,'Single socket',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(212,'single switch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0212','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(213,'Single switch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(214,'Small basket',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(215,'Small bulb holder',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(216,'Small grater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(217,'Small red heater',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0217','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(218,'Small washing brush',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0218','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(219,'Sony MDR qi40',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0219','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(220,'Sparko super glue',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0220','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(221,'Spirit 300ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(222,'spirit 500ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(223,'Spoons',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0223','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(224,'Sports earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0224','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(225,'Suer headphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0225','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(226,'Sunlight 30 bob',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0226','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(227,'Sunlight 30 bob',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0227','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(228,'Switch small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(229,'Tecno batteries',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0229','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-23 14:17:59'),(230,'Tecno box earphones',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0230','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(231,'Tester small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0231','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(232,'Toceball AAA Battery',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(233,'Tooth picks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0233','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(234,'Toothbrush',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0234','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(235,'Top plug',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(236,'Top security absurd',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0236','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(237,'Toy car',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0237','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(238,'Toy phone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(239,'Tri cycle 266',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0239','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(240,'Tri-cyle 262',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(241,'Tri-cyle 263',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0241','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-18 17:33:29'),(242,'Tri-cyle 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0242','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(243,'Tri-cyle 265',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0243','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(244,'Trousers white',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0244','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(245,'Turksun watch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(246,'Tv mount',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(247,'U and I cable',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(248,'U and I earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0248','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(249,'U music 19 earphone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0249','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(250,'Universal 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(251,'Vga',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(252,'Villaon phone',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0252','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(253,'Villaontel type c',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0253','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(254,'Water gun',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0254','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(255,'water heater (gold)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(256,'Whistle',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0256','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(257,'Wireless mouse',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0257','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(258,'Yongli 262',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(259,'Yongli 262',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0259','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(260,'Yongli 263',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(261,'yongli 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(262,'yongli 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:51','2024-09-16 17:32:51'),(263,'yongli 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0263','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(264,'Yongli 264',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(265,'Yongli 265',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0265','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(266,'Yongli 266',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,NULL,'0266','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-09-16 17:32:52','2024-09-16 17:32:52'),(267,'Itel normal charger',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0267','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2024-09-17 10:17:38','2024-09-17 10:17:38'),(268,'Oraimo org cable normal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'0268','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','',NULL,NULL,1,NULL,NULL,0,0,'2024-09-18 19:48:54','2024-09-23 14:19:32'),(269,'Tusker',2,'single',2,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0269','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,0,0,'2024-10-16 16:41:10','2024-10-16 16:41:10');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchase_lines` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `variation_id` int unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int DEFAULT NULL,
  `purchase_order_line_id` int DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,2,39,39,10.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-16 19:39:48','2024-09-16 19:46:06'),(2,3,167,167,1.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-16 19:41:33','2024-09-16 19:46:08'),(3,4,31,31,1.0000,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-16 19:43:16','2024-09-16 19:46:10'),(4,10,267,267,3.0000,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-17 10:18:06','2024-09-23 14:21:21'),(5,15,27,27,6.0000,0.0000,40.0000,0.00,40.0000,40.0000,0.0000,NULL,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-17 13:28:35','2024-09-24 16:06:51'),(6,17,28,28,5.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-17 16:50:05','2024-09-27 08:19:39'),(7,20,166,166,1.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-17 17:31:32','2024-09-17 17:32:08'),(8,28,241,241,1.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-18 17:33:46','2024-09-18 17:34:37'),(9,30,131,131,10.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-18 19:47:33','2024-09-18 19:52:43'),(10,31,268,268,1.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-18 19:50:03','2024-09-23 14:21:21'),(11,32,177,177,3.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-18 19:51:10','2024-09-18 19:51:10'),(12,33,178,178,2.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-18 19:51:52','2024-09-18 19:51:52'),(13,37,64,64,2.0000,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-19 13:52:32','2024-09-19 13:52:32'),(14,38,186,186,2.0000,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-19 13:53:49','2024-09-19 13:53:49'),(15,45,124,124,3.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 14:17:35','2024-09-23 14:17:35'),(16,46,229,229,2.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 14:18:07','2024-09-23 14:18:07'),(17,50,27,27,6.0000,0.0000,40.0000,0.00,40.0000,40.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 17:53:40','2024-09-23 17:53:40'),(18,50,268,268,2.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 17:53:40','2024-09-27 08:19:39'),(19,50,267,267,1.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 17:53:41','2024-09-27 08:19:39'),(20,50,31,31,3.0000,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-23 17:53:41','2024-09-23 17:53:41'),(21,52,76,76,1.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-24 09:52:33','2024-09-24 09:55:58'),(22,55,163,163,3.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-24 16:07:57','2024-09-24 16:08:24'),(23,59,269,269,24.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-10-16 16:41:29','2024-10-16 16:42:25');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reference_counts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int NOT NULL,
  `business_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',4,1,'2024-09-16 18:47:15','2024-09-23 17:51:35'),(2,'business_location',2,1,'2024-09-16 18:47:16','2024-09-16 19:49:14'),(3,'sell_payment',39,1,'2024-09-16 17:35:29','2024-09-27 08:17:49'),(4,'draft',1,1,'2024-09-16 19:55:35','2024-09-16 19:55:35'),(5,'expense',6,1,'2024-09-16 20:00:39','2024-09-24 16:11:05'),(6,'purchase',1,1,'2024-09-23 17:53:35','2024-09-23 17:53:35'),(7,'purchase_payment',1,1,'2024-09-23 17:53:41','2024-09-23 17:53:41'),(8,'contacts',1,2,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(9,'business_location',1,2,'2024-10-14 12:22:39','2024-10-14 12:22:39'),(10,'sell_payment',2,2,'2024-10-16 16:42:24','2024-10-16 16:44:23'),(11,'expense',1,2,'2024-10-16 16:44:23','2024-10-16 16:44:23'),(13,'contacts',1,4,'2024-11-20 23:50:03','2024-11-20 23:50:03'),(14,'business_location',1,4,'2024-11-20 23:50:07','2024-11-20 23:50:07'),(15,'contacts',1,5,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(16,'business_location',1,5,'2024-11-21 00:11:28','2024-11-21 00:11:28'),(17,'contacts',1,6,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(18,'business_location',1,6,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_tables` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `location_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (25,2),(26,2),(48,2),(49,2),(50,2),(51,2),(80,2),(25,4),(26,4),(48,4),(49,4),(50,4),(51,4),(80,4),(25,8),(26,8),(48,8),(49,8),(50,8),(51,8),(80,8),(25,10),(26,10),(48,10),(49,10),(50,10),(51,10),(80,10),(6,11),(81,11),(87,11),(25,13),(26,13),(48,13),(49,13),(50,13),(51,13),(80,13);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2024-09-16 18:47:15','2024-09-16 18:47:15'),(2,'Cashier#1','web',1,0,0,'2024-09-16 18:47:15','2024-09-16 18:47:15'),(3,'Admin#2','web',2,1,0,'2024-10-14 12:22:35','2024-10-14 12:22:35'),(4,'Cashier#2','web',2,0,0,'2024-10-14 12:22:36','2024-10-14 12:22:36'),(7,'Admin#4','web',4,1,0,'2024-11-20 23:50:00','2024-11-20 23:50:00'),(8,'Cashier#4','web',4,0,0,'2024-11-20 23:50:01','2024-11-20 23:50:01'),(9,'Admin#5','web',5,1,0,'2024-11-21 00:11:18','2024-11-21 00:11:18'),(10,'Cashier#5','web',5,0,0,'2024-11-21 00:11:20','2024-11-21 00:11:20'),(11,'Manager#5','web',5,0,0,'2024-11-21 20:01:39','2024-11-21 20:01:39'),(12,'Admin#6','web',6,1,0,'2024-11-24 00:36:50','2024-11-24 00:36:50'),(13,'Cashier#6','web',6,0,0,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int NOT NULL,
  `warranty_id` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `selling_price_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `business_id` int unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `variation_id` int unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int DEFAULT NULL,
  `lot_no_line_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscriptions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `package_id` int unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `package_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_id` int unsigned NOT NULL,
  `paid_via` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_transaction_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('approved','waiting','declined') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,2,1,'2024-10-14','2024-11-28','2024-11-14',20.0000,'{\"location_count\":1,\"user_count\":2,\"product_count\":0,\"invoice_count\":0,\"name\":\"BRONZE\"}',1,'pesapal','vcxgvhbjklm;jhgfcdcgv','approved',NULL,'2024-10-14 14:45:53','2024-10-14 14:45:53'),(2,1,1,'2024-10-14','2024-11-28','2024-11-14',20.0000,'{\"location_count\":1,\"user_count\":2,\"product_count\":0,\"invoice_count\":0,\"name\":\"BRONZE\"}',1,'pesapal',NULL,'approved',NULL,'2024-10-14 15:02:15','2024-10-14 15:02:15'),(3,1,1,'2024-11-15','2024-12-29','2024-12-15',20.0000,'{\"location_count\":1,\"user_count\":2,\"product_count\":0,\"invoice_count\":0,\"name\":\"BRONZE\"}',1,'offline',NULL,'approved',NULL,'2024-10-15 22:25:40','2024-11-21 23:09:44'),(4,5,3,'2024-11-22','2024-12-03','2024-12-31',24499.0000,'{\"location_count\":6,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"One Time Package\"}',1,'pesapal','errrrrr','approved',NULL,'2024-11-21 22:44:22','2024-11-21 23:16:51'),(5,5,1,'2024-12-23','2025-02-06','2025-01-23',999.0000,'{\"location_count\":\"1\",\"user_count\":\"0\",\"product_count\":\"0\",\"invoice_count\":\"0\",\"name\":\"BRONZE\"}',5,'offline',NULL,'approved',NULL,'2024-11-21 20:20:50','2024-11-21 23:08:37'),(6,6,1,'2024-11-23','2025-01-06','2024-12-23',10.0000,'{\"location_count\":1,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"BRONZE\"}',6,'offline',NULL,'approved',NULL,'2024-11-23 22:16:18','2024-11-24 00:47:52');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `system` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','6.3'),(2,'default_business_active_status','1'),(3,'superadmin_version','2.5'),(4,'app_currency_id','133'),(5,'invoice_business_name','JUSTIZ POS PRO'),(6,'invoice_business_landmark','Landmark'),(7,'invoice_business_zip','Zip'),(8,'invoice_business_state','State'),(9,'invoice_business_city','City'),(10,'invoice_business_country','Country'),(11,'email','superadmin@example.com'),(12,'package_expiry_alert_days','5'),(13,'superadmin_register_tc',NULL),(14,'welcome_email_subject',NULL),(15,'welcome_email_body',NULL),(16,'additional_js',NULL),(17,'additional_css',NULL),(18,'offline_payment_details','LIPA NA MPESA TILL 4755742'),(19,'enable_business_based_username','0'),(20,'superadmin_enable_register_tc','0'),(21,'allow_email_settings_to_businesses','0'),(22,'enable_new_business_registration_notification','0'),(23,'enable_new_subscription_notification','0'),(24,'enable_welcome_email','0'),(25,'enable_offline_payment','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_rates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `for_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_payments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int unsigned DEFAULT NULL,
  `business_id` int DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT '0',
  `gateway` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT '0',
  `payment_for` int DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int DEFAULT NULL,
  `note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (2,5,1,0,1150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 22:46:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0002',NULL,'2024-09-16 19:46:00','2024-09-16 19:46:00'),(3,6,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 22:58:33',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0003',NULL,'2024-09-16 19:58:35','2024-09-16 19:58:35'),(4,7,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 22:59:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0004',NULL,'2024-09-16 20:00:47','2024-09-16 20:00:47'),(5,9,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 12:46:17',1,0,NULL,0,3,NULL,NULL,NULL,'SP2024/0005',NULL,'2024-09-17 09:46:17','2024-09-17 09:46:17'),(6,11,1,0,350.0000,'custom_pay_1',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 13:18:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0006',NULL,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(7,12,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 13:59:19',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0007',NULL,'2024-09-17 10:59:19','2024-09-17 10:59:19'),(8,13,1,0,300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 14:41:25',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0008',NULL,'2024-09-17 11:41:25','2024-09-17 11:41:25'),(9,14,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 14:49:32',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0009',NULL,'2024-09-17 11:49:32','2024-09-17 11:49:32'),(10,16,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 16:29:50',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0010',NULL,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(11,18,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 19:51:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0011',NULL,'2024-09-17 16:51:21','2024-09-17 16:51:21'),(12,19,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 20:28:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0012',NULL,'2024-09-17 17:28:21','2024-09-17 17:28:21'),(13,21,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 20:32:08',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0013',NULL,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(14,22,1,0,650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 20:32:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0014',NULL,'2024-09-17 17:33:57','2024-09-17 17:33:57'),(15,23,1,0,150.0000,'custom_pay_1',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 14:40:39',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0015',NULL,'2024-09-18 11:40:40','2024-09-18 11:40:40'),(16,24,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 20:01:01',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0016',NULL,'2024-09-18 17:01:01','2024-09-18 17:01:01'),(17,25,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 20:03:52',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0017',NULL,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(18,26,1,0,350.0000,'custom_pay_1',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 20:04:47',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0018',NULL,'2024-09-18 17:04:47','2024-09-18 17:04:47'),(19,27,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 20:05:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0019',NULL,'2024-09-18 17:14:12','2024-09-18 17:14:12'),(20,29,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 20:34:37',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0020',NULL,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(21,34,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 22:52:43',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0021',NULL,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(22,35,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 22:53:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0022',NULL,'2024-09-18 19:53:33','2024-09-18 19:53:33'),(23,36,1,0,120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-19 14:09:22',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0023',NULL,'2024-09-19 11:09:23','2024-09-19 11:09:23'),(24,39,1,0,600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-20 22:36:42',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0024',NULL,'2024-09-20 19:36:42','2024-09-20 19:36:42'),(25,40,1,0,300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-20 22:37:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0025',NULL,'2024-09-20 19:37:24','2024-09-20 19:37:24'),(26,41,1,0,250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-20 22:40:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0026',NULL,'2024-09-20 19:40:51','2024-09-20 19:40:51'),(27,42,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-20 22:42:22',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0027',NULL,'2024-09-20 19:42:23','2024-09-20 19:42:23'),(28,43,1,0,250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 16:52:12',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0028',NULL,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(29,44,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 16:53:31',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0029',NULL,'2024-09-23 13:53:31','2024-09-23 13:53:31'),(30,47,1,0,650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 17:21:20',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0030',NULL,'2024-09-23 14:21:20','2024-09-23 14:21:20'),(31,48,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 17:24:47',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0031',NULL,'2024-09-23 14:24:47','2024-09-23 14:24:47'),(32,49,1,0,1570.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 20:48:58',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0032',NULL,'2024-09-23 17:48:59','2024-09-23 17:48:59'),(33,50,1,0,950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 20:51:00',1,0,NULL,0,4,NULL,NULL,NULL,'PP2024/0001',NULL,'2024-09-23 17:53:41','2024-09-23 17:53:41'),(34,51,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 20:54:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0033',NULL,'2024-09-23 18:01:41','2024-09-23 18:01:41'),(35,53,1,0,550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 12:55:58',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0034',NULL,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(36,54,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:06:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0035',NULL,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(37,56,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:08:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0036',NULL,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(38,57,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:09:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0037',NULL,'2024-09-24 16:11:05','2024-09-24 16:11:05'),(39,58,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-27 11:13:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0038',NULL,'2024-09-27 08:15:08','2024-09-27 08:15:08'),(40,60,2,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-16 19:42:25',2,0,NULL,0,5,NULL,NULL,NULL,'SP2024/0001',NULL,'2024-10-16 16:42:25','2024-10-16 16:42:25'),(41,61,2,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-16 19:43:00',2,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0002',NULL,'2024-10-16 16:44:23','2024-10-16 16:44:23');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `variation_id` int unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int unsigned DEFAULT NULL,
  `discount_id` int DEFAULT NULL,
  `lot_no_line_id` int DEFAULT NULL,
  `sell_line_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `so_line_id` int DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `res_service_staff_id` int DEFAULT NULL,
  `res_line_order_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_sell_line_id` int DEFAULT NULL,
  `children_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (3,5,39,39,2.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:45:52','2024-09-16 19:45:52'),(4,5,167,167,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:45:52','2024-09-16 19:45:52'),(5,5,31,31,1.0000,0.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:45:52','2024-09-16 19:45:52'),(6,5,200,200,1.0000,0.0000,0.0000,600.0000,600.0000,'fixed',0.0000,600.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:45:53','2024-09-16 19:45:53'),(7,6,79,79,2.0000,0.0000,0.0000,375.0000,375.0000,'fixed',0.0000,375.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:55:38','2024-09-16 19:58:27'),(8,6,93,93,1.0000,0.0000,0.0000,700.0000,700.0000,'fixed',0.0000,700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-16 19:55:39','2024-09-16 19:58:29'),(9,8,85,85,11.0000,0.0000,0.0000,20.0000,20.0000,'fixed',0.0000,20.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 09:26:27','2024-09-17 09:26:27'),(10,9,27,27,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 09:46:17','2024-09-17 09:46:17'),(11,9,200,200,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 09:46:17','2024-09-17 09:46:17'),(12,11,267,267,1.0000,0.0000,0.0000,350.0000,350.0000,'fixed',0.0000,350.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(13,12,200,200,1.0000,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 10:59:19','2024-09-17 10:59:19'),(14,13,200,200,1.0000,0.0000,0.0000,300.0000,300.0000,'fixed',0.0000,300.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 11:41:25','2024-09-17 11:41:25'),(15,14,200,200,1.0000,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 11:49:32','2024-09-17 11:49:32'),(16,16,27,27,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(17,18,27,27,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 16:51:20','2024-09-17 16:51:20'),(18,18,28,28,1.0000,0.0000,0.0000,200.0000,200.0000,'fixed',0.0000,200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 16:51:20','2024-09-17 16:51:20'),(19,18,200,200,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 16:51:20','2024-09-17 16:51:20'),(20,19,19,19,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 17:28:21','2024-09-17 17:28:21'),(21,21,166,166,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(22,23,200,200,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 11:40:38','2024-09-18 11:40:38'),(23,24,200,200,1.0000,0.0000,0.0000,1300.0000,1300.0000,'fixed',0.0000,1300.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 17:01:01','2024-09-18 17:01:01'),(24,25,27,27,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(25,25,267,267,1.0000,0.0000,0.0000,350.0000,350.0000,'fixed',0.0000,350.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(26,26,93,93,1.0000,0.0000,0.0000,350.0000,350.0000,'fixed',0.0000,350.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 17:04:47','2024-09-18 17:04:47'),(27,29,241,241,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(28,34,200,200,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(29,34,131,131,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(30,36,200,200,1.0000,0.0000,0.0000,120.0000,120.0000,'fixed',0.0000,120.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-19 11:09:21','2024-09-19 11:09:21'),(31,39,200,200,1.0000,0.0000,0.0000,600.0000,600.0000,'fixed',0.0000,600.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-20 19:36:41','2024-09-20 19:36:41'),(32,40,93,93,1.0000,0.0000,0.0000,300.0000,300.0000,'fixed',0.0000,300.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-20 19:37:24','2024-09-20 19:37:24'),(33,41,93,93,1.0000,0.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-20 19:40:51','2024-09-20 19:40:51'),(34,42,93,93,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-20 19:42:22','2024-09-20 19:42:22'),(35,43,200,200,1.0000,0.0000,0.0000,200.0000,200.0000,'fixed',0.0000,200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(36,43,100,100,1.0000,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(37,44,79,79,1.0000,0.0000,0.0000,350.0000,350.0000,'fixed',0.0000,350.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 13:53:31','2024-09-23 13:53:31'),(38,44,93,93,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 13:53:31','2024-09-23 13:53:31'),(39,47,267,267,1.0000,0.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 14:21:20','2024-09-23 14:21:20'),(40,47,28,28,1.0000,0.0000,0.0000,200.0000,200.0000,'fixed',0.0000,200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 14:21:20','2024-09-23 14:21:20'),(41,47,268,268,1.0000,0.0000,0.0000,200.0000,200.0000,'fixed',0.0000,200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 14:21:20','2024-09-23 14:21:20'),(42,48,200,200,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 14:24:47','2024-09-23 14:24:47'),(43,49,200,200,1.0000,0.0000,0.0000,1570.0000,1570.0000,'fixed',0.0000,1570.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-23 17:48:58','2024-09-23 17:48:58'),(44,53,200,200,1.0000,0.0000,0.0000,400.0000,400.0000,'fixed',0.0000,400.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(45,53,76,76,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(46,54,27,27,1.0000,0.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(47,56,163,163,1.0000,0.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(48,58,200,200,1.0000,0.0000,0.0000,1000.0000,1000.0000,'fixed',0.0000,1000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-27 08:15:06','2024-09-27 08:15:06'),(49,60,269,269,5.0000,0.0000,0.0000,200.0000,200.0000,'fixed',0.0000,200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-10-16 16:42:24','2024-10-16 16:42:24');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,3,NULL,1,2.0000,0.0000,'2024-09-16 19:46:06','2024-09-16 19:46:06'),(2,4,NULL,2,1.0000,0.0000,'2024-09-16 19:46:08','2024-09-16 19:46:08'),(3,5,NULL,3,1.0000,0.0000,'2024-09-16 19:46:10','2024-09-16 19:46:10'),(4,12,NULL,4,1.0000,0.0000,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(5,16,NULL,5,1.0000,0.0000,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(6,17,NULL,5,1.0000,0.0000,'2024-09-17 16:51:22','2024-09-17 16:51:22'),(7,18,NULL,6,1.0000,0.0000,'2024-09-17 16:51:22','2024-09-17 16:51:22'),(8,21,NULL,7,1.0000,0.0000,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(9,24,NULL,5,1.0000,0.0000,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(10,25,NULL,4,1.0000,0.0000,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(11,27,NULL,8,1.0000,0.0000,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(12,29,NULL,9,1.0000,0.0000,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(13,39,NULL,4,1.0000,0.0000,'2024-09-23 14:21:21','2024-09-23 14:21:21'),(14,40,NULL,6,1.0000,0.0000,'2024-09-23 14:21:21','2024-09-23 14:21:21'),(15,41,NULL,10,1.0000,0.0000,'2024-09-23 14:21:21','2024-09-23 14:21:21'),(16,45,NULL,21,1.0000,0.0000,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(17,46,NULL,5,1.0000,0.0000,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(18,47,NULL,22,1.0000,0.0000,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(19,49,NULL,23,5.0000,0.0000,'2024-10-16 16:42:25','2024-10-16 16:42:25');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `location_id` int unsigned DEFAULT NULL,
  `is_kitchen_order` tinyint(1) NOT NULL DEFAULT '0',
  `res_table_id` int unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int unsigned DEFAULT NULL,
  `customer_group_id` int DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_repeat_on` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `discount_type` enum('fixed','percentage') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT '0.0000',
  `rp_redeemed` int NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivered_to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_person` bigint DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `shipping_custom_field_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `staff_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_fields_info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `final_total` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `expense_category_id` int unsigned DEFAULT NULL,
  `expense_sub_category_id` int DEFAULT NULL,
  `expense_for` int unsigned DEFAULT NULL,
  `commission_agent` int DEFAULT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `is_suspend` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int DEFAULT NULL,
  `return_parent_id` int DEFAULT NULL,
  `opening_stock_product_id` int DEFAULT NULL,
  `created_by` int unsigned NOT NULL,
  `purchase_requisition_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `prefer_payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefer_payment_account` int DEFAULT NULL,
  `sales_order_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `purchase_order_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_field_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `import_batch` int DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `service_custom_field_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `service_custom_field_3` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `service_custom_field_4` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `service_custom_field_5` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `service_custom_field_6` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT '0',
  `rp_earned` int NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `order_addresses` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recur_repetitions` int DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int DEFAULT NULL,
  `invoice_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int DEFAULT NULL,
  `pay_term_type` enum('days','months') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_group_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  KEY `transactions_delivery_person_index` (`delivery_person`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (2,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:39:46',45.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 19:39:48','2024-09-16 19:39:48'),(3,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:41:29',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,167,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 19:41:32','2024-09-16 19:41:32'),(4,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:43:13',120.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,120.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,31,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 19:43:15','2024-09-16 19:43:15'),(5,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0002','',NULL,NULL,NULL,'2024-09-16 22:45:46',1150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-16 19:45:50','2024-09-16 19:46:04'),(6,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'partial',NULL,1,NULL,'0003','',NULL,NULL,NULL,'2024-09-16 22:55:35',1450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 19:55:35','2024-09-16 19:58:36'),(7,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0001',NULL,NULL,NULL,'2024-09-16 22:59:00',1000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'ZAHRA 250 ,BANK 500 ,250 REBBECA',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 20:00:39','2024-09-16 20:00:50'),(8,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'due',NULL,2,NULL,'0004','',NULL,NULL,NULL,'2024-09-17 12:26:27',220.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,220.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 09:26:27','2024-09-17 09:26:27'),(9,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'partial',NULL,3,NULL,'0005','',NULL,NULL,NULL,'2024-09-17 12:46:17',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 09:46:17','2024-09-17 09:46:17'),(10,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 13:18:06',160.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,267,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 10:18:06','2024-09-17 10:18:06'),(11,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0006','',NULL,NULL,NULL,'2024-09-17 13:18:51',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 10:18:51','2024-09-17 10:18:51'),(12,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0007','',NULL,NULL,NULL,'2024-09-17 13:59:17',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 10:59:18','2024-09-17 10:59:19'),(13,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0008','',NULL,NULL,NULL,'2024-09-17 14:41:25',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 11:41:25','2024-09-17 11:41:26'),(14,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0009','',NULL,NULL,NULL,'2024-09-17 14:49:31',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 11:49:32','2024-09-17 11:49:33'),(15,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:28:35',40.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,27,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 13:28:35','2024-09-17 13:28:35'),(16,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0010','',NULL,NULL,NULL,'2024-09-17 16:29:50',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 13:29:50','2024-09-17 13:29:50'),(17,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 19:50:05',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 16:50:05','2024-09-17 16:50:05'),(18,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0011','',NULL,NULL,NULL,'2024-09-17 19:51:19',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 16:51:20','2024-09-17 16:51:22'),(19,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0012','',NULL,NULL,NULL,'2024-09-17 20:28:21',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 17:28:21','2024-09-17 17:28:21'),(20,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:31:32',70.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,70.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,166,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 17:31:32','2024-09-17 17:31:32'),(21,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0013','',NULL,NULL,NULL,'2024-09-17 20:32:08',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-17 17:32:08','2024-09-17 17:32:08'),(22,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0002',NULL,NULL,NULL,'2024-09-17 20:32:00',650.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Zahra 250 ,fuel 200 ,rebecca 200',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,650.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-17 17:33:57','2024-09-17 17:33:57'),(23,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0014','',NULL,NULL,NULL,'2024-09-18 14:40:37',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 11:40:38','2024-09-18 11:40:43'),(24,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0015','',NULL,NULL,NULL,'2024-09-18 20:01:01',1300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 17:01:01','2024-09-18 17:01:01'),(25,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0016','',NULL,NULL,NULL,'2024-09-18 20:03:52',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 17:03:52','2024-09-18 17:03:52'),(26,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0017','',NULL,NULL,NULL,'2024-09-18 20:04:47',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 17:04:47','2024-09-18 17:04:47'),(27,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0003',NULL,NULL,NULL,'2024-09-18 20:05:00',1500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Purchase550 zahra 250,rebbeca 200 bank 500',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 17:14:12','2024-09-18 17:14:12'),(28,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:33:46',60.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,60.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,241,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 17:33:46','2024-09-18 17:33:46'),(29,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0018','',NULL,NULL,NULL,'2024-09-18 20:34:37',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 17:34:37','2024-09-18 17:34:37'),(30,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:47:33',45.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,131,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 19:47:33','2024-09-18 19:47:33'),(31,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:50:00',100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,268,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 19:50:03','2024-09-23 14:19:47'),(32,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:51:10',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,177,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 19:51:10','2024-09-18 19:51:10'),(33,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 22:51:52',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,178,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 19:51:52','2024-09-18 19:51:52'),(34,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0019','',NULL,NULL,NULL,'2024-09-18 22:52:43',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-18 19:52:43','2024-09-18 19:52:43'),(35,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0004',NULL,NULL,NULL,'2024-09-18 22:53:00',500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Water bill job',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-18 19:53:32','2024-09-18 19:53:33'),(36,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0020','',NULL,NULL,NULL,'2024-09-19 14:09:18',120.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,120.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-19 11:09:19','2024-09-19 11:09:26'),(37,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:52:32',230.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,460.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-19 13:52:32','2024-09-19 13:52:32'),(38,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:53:48',220.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,440.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,186,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-19 13:53:49','2024-09-19 13:53:49'),(39,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0021','',NULL,NULL,NULL,'2024-09-20 22:36:40',600.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-20 19:36:41','2024-09-20 19:36:42'),(40,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0022','',NULL,NULL,NULL,'2024-09-20 22:37:24',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-20 19:37:24','2024-09-20 19:37:25'),(41,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0023','',NULL,NULL,NULL,'2024-09-20 22:40:51',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-20 19:40:51','2024-09-20 19:40:51'),(42,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0024','',NULL,NULL,NULL,'2024-09-20 22:42:22',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-20 19:42:22','2024-09-20 19:42:23'),(43,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0025','',NULL,NULL,NULL,'2024-09-23 16:52:12',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-23 13:52:12','2024-09-23 13:52:12'),(44,1,2,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0026','',NULL,NULL,NULL,'2024-09-23 16:53:31',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-23 13:53:31','2024-09-23 13:53:32'),(45,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 17:17:35',70.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,210.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,124,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 14:17:35','2024-09-23 14:17:35'),(46,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 17:18:07',70.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,140.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,229,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 14:18:07','2024-09-23 14:18:07'),(47,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0027','',NULL,NULL,NULL,'2024-09-23 17:21:20',650.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,650.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-23 14:21:20','2024-09-23 14:21:21'),(48,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0028','',NULL,NULL,NULL,'2024-09-23 17:24:46',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-23 14:24:47','2024-09-23 14:24:47'),(49,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0029','',NULL,NULL,NULL,'2024-09-23 20:48:56',1570.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1570.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-23 17:48:57','2024-09-23 17:49:00'),(50,1,1,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'paid',NULL,4,NULL,NULL,'PO2024/0001',NULL,NULL,NULL,'2024-09-23 20:51:00',950.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,950.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 17:53:35','2024-09-23 17:53:41'),(51,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0005',NULL,NULL,NULL,'2024-09-23 20:54:00',1450.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Zahra 250 ,shopping 950',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-23 18:01:39','2024-09-23 18:01:41'),(52,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 12:52:33',60.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,60.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:52:33','2024-09-24 09:52:33'),(53,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0030','',NULL,NULL,NULL,'2024-09-24 12:55:58',550.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,550.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-24 09:55:58','2024-09-24 09:55:58'),(54,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0031','',NULL,NULL,NULL,'2024-09-24 19:06:51',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-24 16:06:51','2024-09-24 16:06:51'),(55,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 19:07:57',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,163,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 16:07:57','2024-09-24 16:07:57'),(56,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0032','',NULL,NULL,NULL,'2024-09-24 19:08:24',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-09-24 16:08:24','2024-09-24 16:08:24'),(57,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'partial',NULL,NULL,NULL,NULL,'EP2024/0006',NULL,NULL,NULL,'2024-09-24 19:09:00',375.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Zahra 250 ,rebbeca 150',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 16:11:05','2024-09-24 16:11:05'),(58,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0033','',NULL,NULL,NULL,'2024-09-25 11:13:00',1000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-27 08:15:05','2024-09-27 08:15:08'),(59,2,3,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 19:41:29',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,269,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-16 16:41:29','2024-10-16 16:41:29'),(60,2,3,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,5,NULL,'0001','',NULL,NULL,NULL,'2024-10-16 19:42:24',1000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2024-10-16 16:42:24','2024-10-16 16:42:25'),(61,2,3,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2024/0001',NULL,NULL,NULL,'2024-10-16 19:43:00',100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'Staff',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-16 16:44:23','2024-10-16 16:44:24');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `types_of_services` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `business_id` int NOT NULL,
  `location_price_group` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `units` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int unsigned NOT NULL,
  `actual_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'pcs','pcs',0,NULL,NULL,1,NULL,'2024-09-16 18:47:15','2024-09-16 17:32:09'),(2,2,'Pieces','Pc(s)',0,NULL,NULL,2,NULL,'2024-10-14 12:22:38','2024-10-14 12:22:38'),(4,4,'Pieces','Pc(s)',0,NULL,NULL,4,NULL,'2024-11-20 23:50:05','2024-11-20 23:50:05'),(5,5,'Pieces','Pc(s)',0,NULL,NULL,5,NULL,'2024-11-21 00:11:24','2024-11-21 00:11:24'),(6,6,'Pieces','Pc(s)',0,NULL,NULL,6,NULL,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_contact_access` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `contact_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `surname` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int unsigned DEFAULT NULL,
  `available_at` datetime DEFAULT NULL COMMENT 'Service staff avilable at. Calculated from product preparation_time_in_minutes',
  `paused_at` datetime DEFAULT NULL COMMENT 'Service staff available time paused at, Will be nulled on resume.',
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT '1',
  `status` enum('active','inactive','terminated') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `is_enable_service_staff_pin` tinyint(1) NOT NULL DEFAULT '0',
  `service_staff_pin` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `crm_contact_id` int unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `selected_contacts` tinyint(1) NOT NULL DEFAULT '0',
  `dob` date DEFAULT NULL,
  `gender` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blood_group` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_number` char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `family_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fb_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permanent_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `current_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `guardian_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `id_proof_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_proof_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_crm_contact_id_foreign` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user','mr','peter','kalei','admin','ptakalei@gmail.com','$2y$10$yqr.TY0E4Y2XamPXwD0Ef.5neTbRumEUadM6LqjePWc3QcCu5VnrW','en',NULL,NULL,'uDoir9C4Xg3A6hqAWjBZ5vE0kC8f9f9XvrpOeSemeHOySh26JPyIBT8WLvTX',1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-16 18:47:15','2024-09-16 18:47:15'),(2,'user','MR','peter','kalei','test','TEST@G.COM','$2y$10$3euZIzTPR2KTVlilXBDhWOFhYqiKDxYgbQF3cLT8OvDTet./X7SwG','en',NULL,NULL,'7PQhbZ3n36VNqL09u5BPWgQsHimKAMVvbQqgUja2NarOn3cLNsRYy1RMgYd0',2,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-14 12:22:35','2024-10-14 12:22:35'),(4,'user',NULL,'jayjay','mungai','mungai','mungai@gmail.com','$2y$10$vMi8QzRWAr44pt.SO77Ml.UqJ.zSIUI2wb8pBFNEv03hDyK54SAsa','en',NULL,NULL,NULL,4,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-20 23:50:00','2024-11-20 23:50:00'),(5,'user','MR','MWENDA',NULL,'mwenda','mwenda@gmail.com','$2y$10$23bdg4p7XaPtYYfmBmE/deYnUJwxlLVH4w2Iwb3/AoYFV.4kM.QOq','en',NULL,NULL,NULL,5,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-21 00:11:17','2024-11-21 00:11:17'),(6,'user',NULL,'mwanzo',NULL,'mwanzo','mwanzo@gmail.com','$2y$10$4OuJYhUG3X3waGKKWOAWVeXMwOxQN6UNkymiT3F8TFggL2MyFgrA2','en',NULL,NULL,NULL,6,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-24 00:36:50','2024-11-24 00:36:50');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_group_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int unsigned NOT NULL,
  `price_group_id` int unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `price_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_location_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int unsigned NOT NULL,
  `product_variation_id` int unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int unsigned NOT NULL,
  `location_id` int unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,39,39,39,1,8.0000,'2024-09-16 19:39:48','2024-09-16 19:46:00'),(2,167,167,167,1,0.0000,'2024-09-16 19:41:30','2024-09-16 19:46:02'),(3,31,31,31,1,3.0000,'2024-09-16 19:43:13','2024-09-23 17:53:40'),(4,267,267,267,1,1.0000,'2024-09-17 10:18:06','2024-09-27 08:19:39'),(5,27,27,27,1,8.0000,'2024-09-17 13:28:35','2024-09-24 16:06:51'),(6,28,28,28,1,3.0000,'2024-09-17 16:50:05','2024-09-27 08:19:39'),(7,166,166,166,1,0.0000,'2024-09-17 17:31:32','2024-09-17 17:32:08'),(8,241,241,241,1,0.0000,'2024-09-18 17:33:46','2024-09-18 17:34:37'),(9,131,131,131,1,9.0000,'2024-09-18 19:47:33','2024-09-18 19:52:43'),(10,268,268,268,1,2.0000,'2024-09-18 19:50:02','2024-09-27 08:19:39'),(11,177,177,177,1,3.0000,'2024-09-18 19:51:10','2024-09-18 19:51:10'),(12,178,178,178,1,2.0000,'2024-09-18 19:51:52','2024-09-18 19:51:52'),(13,64,64,64,1,2.0000,'2024-09-19 13:52:32','2024-09-19 13:52:32'),(14,186,186,186,1,2.0000,'2024-09-19 13:53:48','2024-09-19 13:53:48'),(15,124,124,124,1,3.0000,'2024-09-23 14:17:35','2024-09-23 14:17:35'),(16,229,229,229,1,2.0000,'2024-09-23 14:18:07','2024-09-23 14:18:07'),(17,76,76,76,1,0.0000,'2024-09-24 09:52:33','2024-09-24 09:55:58'),(18,163,163,163,1,2.0000,'2024-09-24 16:07:57','2024-09-24 16:08:24'),(19,269,269,269,3,19.0000,'2024-10-16 16:41:29','2024-10-16 16:42:25');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_value_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int unsigned NOT NULL,
  `sub_sku` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int unsigned NOT NULL,
  `variation_value_id` int DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `profit_percent` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'0001',1,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(2,'DUMMY',2,'0002',2,NULL,150.0000,150.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(3,'DUMMY',3,'0003',3,NULL,180.0000,180.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(4,'DUMMY',4,'0004',4,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(5,'DUMMY',5,'0005',5,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(6,'DUMMY',6,'0006',6,NULL,430.0000,430.0000,25.0000,650.0000,650.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(7,'DUMMY',7,'0007',7,NULL,350.0000,350.0000,25.0000,650.0000,650.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(8,'DUMMY',8,'0008',8,NULL,40.0000,40.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(9,'DUMMY',9,'0009',9,NULL,30.0000,30.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(10,'DUMMY',10,'0010',10,NULL,40.0000,40.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(11,'DUMMY',11,'0011',11,NULL,40.0000,40.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(12,'DUMMY',12,'0012',12,NULL,30.0000,30.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(13,'DUMMY',13,'0013',13,NULL,550.0000,550.0000,25.0000,750.0000,750.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(14,'DUMMY',14,'0014',14,NULL,400.0000,400.0000,25.0000,750.0000,750.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(15,'DUMMY',15,'0015',15,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(16,'DUMMY',16,'0016',16,NULL,280.0000,280.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(17,'DUMMY',17,'0017',17,NULL,270.0000,270.0000,25.0000,450.0000,450.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(18,'DUMMY',18,'0018',18,NULL,35.0000,35.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(19,'DUMMY',19,'0019',19,NULL,80.0000,80.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(20,'DUMMY',20,'0020',20,NULL,400.0000,400.0000,25.0000,600.0000,600.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(21,'DUMMY',21,'0021',21,NULL,320.0000,320.0000,25.0000,550.0000,550.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(22,'DUMMY',22,'0022',22,NULL,20.0000,20.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(23,'DUMMY',23,'0023',23,NULL,320.0000,320.0000,25.0000,550.0000,550.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(24,'DUMMY',24,'0024',24,NULL,20.0000,20.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(25,'DUMMY',25,'0025',25,NULL,10.0000,10.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(26,'DUMMY',26,'0026',26,NULL,150.0000,150.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(27,'DUMMY',27,'0027',27,NULL,40.0000,40.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:49','2024-09-17 13:28:09',NULL,'[]'),(28,'DUMMY',28,'0028',28,NULL,50.0000,50.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:49','2024-09-17 16:49:36',NULL,'[]'),(29,'DUMMY',29,'0029',29,NULL,50.0000,50.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(30,'DUMMY',30,'0030',30,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(31,'DUMMY',31,'0031',31,NULL,120.0000,120.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:49','2024-09-16 19:42:42',NULL,'[]'),(32,'DUMMY',32,'0032',32,NULL,50.0000,50.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:49','2024-09-16 17:32:49',NULL,'[]'),(33,'DUMMY',33,'0033',33,NULL,50.0000,50.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(34,'DUMMY',34,'0034',34,NULL,40.0000,40.0000,25.0000,80.0000,80.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(35,'DUMMY',35,'0035',35,NULL,65.0000,65.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(36,'DUMMY',36,'0036',36,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(37,'DUMMY',37,'0037',37,NULL,270.0000,270.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(38,'DUMMY',38,'0038',38,NULL,250.0000,250.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(39,'DUMMY',39,'0039',39,NULL,45.0000,45.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 19:39:23',NULL,'[]'),(40,'DUMMY',40,'0040',40,NULL,55.0000,55.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(41,'DUMMY',41,'0041',41,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(42,'DUMMY',42,'0042',42,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(43,'DUMMY',43,'0043',43,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(44,'DUMMY',44,'0044',44,NULL,80.0000,80.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(45,'DUMMY',45,'0045',45,NULL,180.0000,180.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(46,'DUMMY',46,'0046',46,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(47,'DUMMY',47,'0047',47,NULL,30.0000,30.0000,25.0000,60.0000,60.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(48,'DUMMY',48,'0048',48,NULL,0.0000,0.0000,25.0000,600.0000,600.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(49,'DUMMY',49,'0049',49,NULL,50.0000,50.0000,25.0000,70.0000,70.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(50,'DUMMY',50,'0050',50,NULL,35.0000,35.0000,25.0000,70.0000,70.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(51,'DUMMY',51,'0051',51,NULL,110.0000,110.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(52,'DUMMY',52,'0052',52,NULL,180.0000,180.0000,25.0000,300.0000,300.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(53,'DUMMY',53,'0053',53,NULL,20.0000,20.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(54,'DUMMY',54,'0054',54,NULL,12.0000,12.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(55,'DUMMY',55,'0055',55,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(56,'DUMMY',56,'0056',56,NULL,200.0000,200.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(57,'DUMMY',57,'0057',57,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(58,'DUMMY',58,'0058',58,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(59,'DUMMY',59,'0059',59,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(60,'DUMMY',60,'0060',60,NULL,250.0000,250.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(61,'DUMMY',61,'0061',61,NULL,65.0000,65.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(62,'DUMMY',62,'0062',62,NULL,70.0000,70.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(63,'DUMMY',63,'0063',63,NULL,65.0000,65.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(64,'DUMMY',64,'0064',64,NULL,230.0000,230.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-19 13:51:57',NULL,'[]'),(65,'DUMMY',65,'0065',65,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(66,'DUMMY',66,'0066',66,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(67,'DUMMY',67,'0067',67,NULL,9.0000,9.0000,25.0000,15.0000,15.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(68,'DUMMY',68,'0068',68,NULL,110.0000,110.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(69,'DUMMY',69,'0069',69,NULL,0.0000,0.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(70,'DUMMY',70,'0070',70,NULL,40.0000,40.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(71,'DUMMY',71,'0071',71,NULL,0.0000,0.0000,25.0000,1300.0000,1300.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(72,'DUMMY',72,'0072',72,NULL,160.0000,160.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(73,'DUMMY',73,'0073',73,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(74,'DUMMY',74,'0074',74,NULL,20.0000,20.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(75,'DUMMY',75,'0075',75,NULL,380.0000,380.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(76,'DUMMY',76,'0076',76,NULL,60.0000,60.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-24 09:52:18',NULL,'[]'),(77,'DUMMY',77,'0077',77,NULL,0.0000,0.0000,25.0000,300.0000,300.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(78,'DUMMY',78,'0078',78,NULL,0.0000,0.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(79,'DUMMY',79,'0079',79,NULL,0.0000,0.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(80,'DUMMY',80,'0080',80,NULL,0.0000,0.0000,25.0000,450.0000,450.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(81,'DUMMY',81,'0081',81,NULL,350.0000,350.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(82,'DUMMY',82,'0082',82,NULL,5.0000,5.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(83,'DUMMY',83,'0083',83,NULL,200.0000,200.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(84,'DUMMY',84,'0084',84,NULL,15.0000,15.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(85,'DUMMY',85,'0085',85,NULL,10.0000,10.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(86,'DUMMY',86,'0086',86,NULL,10.0000,10.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(87,'DUMMY',87,'0087',87,NULL,4.0000,4.0000,25.0000,10.0000,10.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(88,'DUMMY',88,'0088',88,NULL,60.0000,60.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(89,'DUMMY',89,'0089',89,NULL,120.0000,120.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(90,'DUMMY',90,'0090',90,NULL,250.0000,250.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(91,'DUMMY',91,'0091',91,NULL,10.0000,10.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(92,'DUMMY',92,'0092',92,NULL,40.0000,40.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(93,'DUMMY',93,'0093',93,NULL,0.0000,0.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(94,'DUMMY',94,'0094',94,NULL,0.0000,0.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(95,'DUMMY',95,'0095',95,NULL,28.0000,28.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(96,'DUMMY',96,'0096',96,NULL,250.0000,250.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(97,'DUMMY',97,'0097',97,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(98,'DUMMY',98,'0098',98,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(99,'DUMMY',99,'0099',99,NULL,20.0000,20.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(100,'DUMMY',100,'0100',100,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(101,'DUMMY',101,'0101',101,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(102,'DUMMY',102,'0102',102,NULL,65.0000,65.0000,25.0000,130.0000,130.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(103,'DUMMY',103,'0103',103,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(104,'DUMMY',104,'0104',104,NULL,6.0000,6.0000,25.0000,10.0000,10.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(105,'DUMMY',105,'0105',105,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(106,'DUMMY',106,'0106',106,NULL,50.0000,50.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(107,'DUMMY',107,'0107',107,NULL,50.0000,50.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(108,'DUMMY',108,'0108',108,NULL,150.0000,150.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(109,'DUMMY',109,'0109',109,NULL,60.0000,60.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(110,'DUMMY',110,'0110',110,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(111,'DUMMY',111,'0111',111,NULL,70.0000,70.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(112,'DUMMY',112,'0112',112,NULL,150.0000,150.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(113,'DUMMY',113,'0113',113,NULL,50.0000,50.0000,25.0000,75.0000,75.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(114,'DUMMY',114,'0114',114,NULL,350.0000,350.0000,25.0000,550.0000,550.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(115,'DUMMY',115,'0115',115,NULL,350.0000,350.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(116,'DUMMY',116,'0116',116,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(117,'DUMMY',117,'0117',117,NULL,50.0000,50.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(118,'DUMMY',118,'0118',118,NULL,15.0000,15.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(119,'DUMMY',119,'0119',119,NULL,100.0000,100.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(120,'DUMMY',120,'0120',120,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(121,'DUMMY',121,'0121',121,NULL,0.0000,0.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(122,'DUMMY',122,'0122',122,NULL,170.0000,170.0000,25.0000,550.0000,550.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(123,'DUMMY',123,'0123',123,NULL,60.0000,60.0000,25.0000,75.0000,75.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(124,'DUMMY',124,'0124',124,NULL,70.0000,70.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-23 14:17:05',NULL,'[]'),(125,'DUMMY',125,'0125',125,NULL,150.0000,150.0000,25.0000,270.0000,270.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(126,'DUMMY',126,'0126',126,NULL,85.0000,85.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(127,'DUMMY',127,'0127',127,NULL,105.0000,105.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(128,'DUMMY',128,'0128',128,NULL,130.0000,130.0000,25.0000,300.0000,300.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(129,'DUMMY',129,'0129',129,NULL,300.0000,300.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(130,'DUMMY',130,'0130',130,NULL,95.0000,95.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(131,'DUMMY',131,'0131',131,NULL,45.0000,45.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-18 19:47:13',NULL,'[]'),(132,'DUMMY',132,'0132',132,NULL,0.0000,0.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(133,'DUMMY',133,'0133',133,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(134,'DUMMY',134,'0134',134,NULL,0.0000,0.0000,25.0000,35.0000,35.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(135,'DUMMY',135,'0135',135,NULL,0.0000,0.0000,25.0000,40.0000,40.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(136,'DUMMY',136,'0136',136,NULL,650.0000,650.0000,25.0000,850.0000,850.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(137,'DUMMY',137,'0137',137,NULL,100.0000,100.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(138,'DUMMY',138,'0138',138,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(139,'DUMMY',139,'0139',139,NULL,40.0000,40.0000,25.0000,60.0000,60.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(140,'DUMMY',140,'0140',140,NULL,120.0000,120.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(141,'DUMMY',141,'0141',141,NULL,150.0000,150.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(142,'DUMMY',142,'0142',142,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(143,'DUMMY',143,'0143',143,NULL,650.0000,650.0000,25.0000,1000.0000,1000.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(144,'DUMMY',144,'0144',144,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(145,'DUMMY',145,'0145',145,NULL,70.0000,70.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(146,'DUMMY',146,'0146',146,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:50','2024-09-16 17:32:50',NULL,'[]'),(147,'DUMMY',147,'0147',147,NULL,160.0000,160.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(148,'DUMMY',148,'0148',148,NULL,40.0000,40.0000,25.0000,70.0000,70.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(149,'DUMMY',149,'0149',149,NULL,0.0000,0.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(150,'DUMMY',150,'0150',150,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(151,'DUMMY',151,'0151',151,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(152,'DUMMY',152,'0152',152,NULL,20.0000,20.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(153,'DUMMY',153,'0153',153,NULL,170.0000,170.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(154,'DUMMY',154,'0154',154,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(155,'DUMMY',155,'0155',155,NULL,20.0000,20.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(156,'DUMMY',156,'0156',156,NULL,20.0000,20.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(157,'DUMMY',157,'0157',157,NULL,200.0000,200.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(158,'DUMMY',158,'0158',158,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(159,'DUMMY',159,'0159',159,NULL,170.0000,170.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(160,'DUMMY',160,'0160',160,NULL,25.0000,25.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(161,'DUMMY',161,'0161',161,NULL,50.0000,50.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(162,'DUMMY',162,'0162',162,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(163,'DUMMY',163,'0163',163,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-24 16:07:44',NULL,'[]'),(164,'DUMMY',164,'0164',164,NULL,30.0000,30.0000,25.0000,70.0000,70.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(165,'DUMMY',165,'0165',165,NULL,120.0000,120.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(166,'DUMMY',166,'0166',166,NULL,70.0000,70.0000,114.2900,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-17 17:31:18',NULL,'[]'),(167,'DUMMY',167,'0167',167,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 19:41:13',NULL,'[]'),(168,'DUMMY',168,'0168',168,NULL,400.0000,400.0000,25.0000,700.0000,700.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(169,'DUMMY',169,'0169',169,NULL,150.0000,150.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(170,'DUMMY',170,'0170',170,NULL,400.0000,400.0000,25.0000,700.0000,700.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(171,'DUMMY',171,'0171',171,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(172,'DUMMY',172,'0172',172,NULL,60.0000,60.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(173,'DUMMY',173,'0173',173,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(174,'DUMMY',174,'0174',174,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(175,'DUMMY',175,'0175',175,NULL,170.0000,170.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(176,'DUMMY',176,'0176',176,NULL,28.0000,28.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(177,'DUMMY',177,'0177',177,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-18 19:50:41',NULL,'[]'),(178,'DUMMY',178,'0178',178,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-18 19:51:39',NULL,'[]'),(179,'DUMMY',179,'0179',179,NULL,150.0000,150.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(180,'DUMMY',180,'0180',180,NULL,450.0000,450.0000,25.0000,650.0000,650.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(181,'DUMMY',181,'0181',181,NULL,5.0000,5.0000,25.0000,35.0000,35.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(182,'DUMMY',182,'0182',182,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(183,'DUMMY',183,'0183',183,NULL,170.0000,170.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(184,'DUMMY',184,'0184',184,NULL,5.0000,5.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(185,'DUMMY',185,'0185',185,NULL,2.0000,2.0000,25.0000,5.0000,5.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(186,'DUMMY',186,'0186',186,NULL,220.0000,220.0000,25.0000,275.0000,275.0000,'2024-09-16 17:32:51','2024-09-19 13:53:34',NULL,'[]'),(187,'DUMMY',187,'0187',187,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(188,'DUMMY',188,'0188',188,NULL,90.0000,90.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(189,'DUMMY',189,'0189',189,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(190,'DUMMY',190,'0190',190,NULL,2.0000,2.0000,25.0000,10.0000,10.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(191,'DUMMY',191,'0191',191,NULL,120.0000,120.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(192,'DUMMY',192,'0192',192,NULL,25.0000,25.0000,25.0000,80.0000,80.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(193,'DUMMY',193,'0193',193,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(194,'DUMMY',194,'0194',194,NULL,50.0000,50.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(195,'DUMMY',195,'0195',195,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(196,'DUMMY',196,'0196',196,NULL,60.0000,60.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(197,'DUMMY',197,'0197',197,NULL,2.2000,2.2000,25.0000,10.0000,10.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(198,'DUMMY',198,'0198',198,NULL,130.0000,130.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(199,'DUMMY',199,'0199',199,NULL,260.0000,260.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(200,'DUMMY',200,'0200',200,NULL,0.0000,0.0000,25.0000,300.0000,300.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(201,'DUMMY',201,'0201',201,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(202,'DUMMY',202,'0202',202,NULL,150.0000,150.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(203,'DUMMY',203,'0203',203,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(204,'DUMMY',204,'0204',204,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(205,'DUMMY',205,'0205',205,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(206,'DUMMY',206,'0206',206,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(207,'DUMMY',207,'0207',207,NULL,18.0000,18.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(208,'DUMMY',208,'0208',208,NULL,40.0000,40.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(209,'DUMMY',209,'0209',209,NULL,0.0000,0.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(210,'DUMMY',210,'0210',210,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(211,'DUMMY',211,'0211',211,NULL,90.0000,90.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(212,'DUMMY',212,'0212',212,NULL,150.0000,150.0000,25.0000,281.2500,281.2500,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(213,'DUMMY',213,'0213',213,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(214,'DUMMY',214,'0214',214,NULL,0.0000,0.0000,25.0000,400.0000,400.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(215,'DUMMY',215,'0215',215,NULL,25.0000,25.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(216,'DUMMY',216,'0216',216,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(217,'DUMMY',217,'0217',217,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(218,'DUMMY',218,'0218',218,NULL,30.0000,30.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(219,'DUMMY',219,'0219',219,NULL,150.0000,150.0000,25.0000,300.0000,300.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(220,'DUMMY',220,'0220',220,NULL,20.0000,20.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(221,'DUMMY',221,'0221',221,NULL,50.0000,50.0000,25.0000,70.0000,70.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(222,'DUMMY',222,'0222',222,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(223,'DUMMY',223,'0223',223,NULL,10.0000,10.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(224,'DUMMY',224,'0224',224,NULL,200.0000,200.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(225,'DUMMY',225,'0225',225,NULL,200.0000,200.0000,25.0000,450.0000,450.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(226,'DUMMY',226,'0226',226,NULL,30.0000,30.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(227,'DUMMY',227,'0227',227,NULL,30.0000,30.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(228,'DUMMY',228,'0228',228,NULL,15.0000,15.0000,25.0000,25.0000,25.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(229,'DUMMY',229,'0229',229,NULL,70.0000,70.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-23 14:17:59',NULL,'[]'),(230,'DUMMY',230,'0230',230,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(231,'DUMMY',231,'0231',231,NULL,30.0000,30.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(232,'DUMMY',232,'0232',232,NULL,4.1100,4.1100,25.0000,15.0000,15.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(233,'DUMMY',233,'0233',233,NULL,12.0000,12.0000,25.0000,20.0000,20.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(234,'DUMMY',234,'0234',234,NULL,10.0000,10.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(235,'DUMMY',235,'0235',235,NULL,35.0000,35.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(236,'DUMMY',236,'0236',236,NULL,280.0000,280.0000,25.0000,350.0000,350.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(237,'DUMMY',237,'0237',237,NULL,100.0000,100.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(238,'DUMMY',238,'0238',238,NULL,50.0000,50.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(239,'DUMMY',239,'0239',239,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(240,'DUMMY',240,'0240',240,NULL,40.0000,40.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(241,'DUMMY',241,'0241',241,NULL,60.0000,60.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-18 17:33:30',NULL,'[]'),(242,'DUMMY',242,'0242',242,NULL,75.0000,75.0000,25.0000,130.0000,130.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(243,'DUMMY',243,'0243',243,NULL,100.0000,100.0000,25.0000,180.0000,180.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(244,'DUMMY',244,'0244',244,NULL,0.0000,0.0000,25.0000,40.0000,40.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(245,'DUMMY',245,'0245',245,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(246,'DUMMY',246,'0246',246,NULL,250.0000,250.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(247,'DUMMY',247,'0247',247,NULL,75.0000,75.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(248,'DUMMY',248,'0248',248,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(249,'DUMMY',249,'0249',249,NULL,50.0000,50.0000,25.0000,150.0000,150.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(250,'DUMMY',250,'0250',250,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(251,'DUMMY',251,'0251',251,NULL,120.0000,120.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(252,'DUMMY',252,'0252',252,NULL,850.0000,850.0000,25.0000,1000.0000,1000.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(253,'DUMMY',253,'0253',253,NULL,100.0000,100.0000,25.0000,200.0000,200.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(254,'DUMMY',254,'0254',254,NULL,70.0000,70.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(255,'DUMMY',255,'0255',255,NULL,150.0000,150.0000,25.0000,280.0000,280.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(256,'DUMMY',256,'0256',256,NULL,10.0000,10.0000,25.0000,30.0000,30.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(257,'DUMMY',257,'0257',257,NULL,350.0000,350.0000,25.0000,500.0000,500.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(258,'DUMMY',258,'0258',258,NULL,45.0000,45.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(259,'DUMMY',259,'0259',259,NULL,45.0000,45.0000,25.0000,50.0000,50.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(260,'DUMMY',260,'0260',260,NULL,65.0000,65.0000,25.0000,100.0000,100.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(261,'DUMMY',261,'0261',261,NULL,90.0000,90.0000,25.0000,180.0000,180.0000,'2024-09-16 17:32:51','2024-09-16 17:32:51',NULL,'[]'),(262,'DUMMY',262,'0262',262,NULL,50.0000,50.0000,25.0000,130.0000,130.0000,'2024-09-16 17:32:52','2024-09-16 17:32:52',NULL,'[]'),(263,'DUMMY',263,'0263',263,NULL,80.0000,80.0000,25.0000,180.0000,180.0000,'2024-09-16 17:32:52','2024-09-16 17:32:52',NULL,'[]'),(264,'DUMMY',264,'0264',264,NULL,65.0000,65.0000,25.0000,130.0000,130.0000,'2024-09-16 17:32:52','2024-09-16 17:32:52',NULL,'[]'),(265,'DUMMY',265,'0265',265,NULL,0.0000,0.0000,25.0000,130.0000,130.0000,'2024-09-16 17:32:52','2024-09-16 17:32:52',NULL,'[]'),(266,'DUMMY',266,'0266',266,NULL,150.0000,150.0000,25.0000,250.0000,250.0000,'2024-09-16 17:32:52','2024-09-16 17:32:52',NULL,'[]'),(267,'DUMMY',267,'0267',267,NULL,150.0000,150.0000,166.6667,400.0000,400.0000,'2024-09-17 10:17:38','2024-09-23 17:53:40',NULL,'[]'),(268,'DUMMY',268,'0268',268,NULL,100.0000,100.0000,25.0000,250.0000,250.0000,'2024-09-18 19:48:54','2024-09-23 14:19:32',NULL,'[]'),(269,'DUMMY',269,'0269',269,NULL,150.0000,150.0000,33.3300,200.0000,200.0000,'2024-10-16 16:41:10','2024-10-16 16:41:10',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `warranties` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `duration` int NOT NULL,
  `duration_type` enum('days','months','years') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warranties_business_id_index` (`business_id`),
  KEY `warranties_duration_type_index` (`duration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

