@if(!session('business.enable_price_tax')) 
  @php
    $default = 0;
    $class = 'hide';
  @endphp
@else
  @php
    $default = null;
    $class = '';
  @endphp
@endif

<div class="table-responsive">
    <table class="table table-bordered add-product-price-table table-condensed {{$class}}">
        <tr>
          <th>@lang('Add Your Hire Price')</th>
          <th>@lang('to this field') @show_tooltip(__('hire price per day'))</th>
          <th>@lang('Hire Price')</th>
          @if(empty($quick_add))
            <th>@lang('Car picture')</th>
          @endif
        </tr>
        <tr>
          <td>
          <div class="form-group " style="display: none;"">
    {!! Form::label('single_dpp', trans('product.exc_of_tax') . ':*') !!}
    <p class="form-control-static">0</p>
    {!! Form::hidden('single_dpp', 0) !!}
</div>

         <div class="form-group " style="display: none;"">
    {!! Form::label('single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
    <p class="form-control-static">0</p>
    {!! Form::hidden('single_dpp_inc_tax', 0) !!}
</div>
          </td>

          <td>
            <br/>
            <div class="form-group " style="display: none;"">
            {!! Form::text('profit_percent', @num_format($profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'profit_percent', 'required']); !!}
          </td>

          <td>
            <label><span class="dsp_label">@lang('Price')</span></label>
            {!! Form::text('single_dsp', $default, ['class' => 'form-control input-sm dsp input_number', 'placeholder' => __('price'), 'id' => 'single_dsp', 'required']); !!}

            {!! Form::text('price', $default, ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('price'), 'id' => 'single_dsp_inc_tax', 'required']); !!}
          </td>
          @if(empty($quick_add))
          <td>
              <div class="form-group">
                {!! Form::label('variation_images', __('Not Mandatory') . ':') !!}
                {!! Form::file('variation_images[]', ['class' => 'variation_images', 
                    'accept' => 'image/*', 'multiple']); !!}
                <small><p class="help-block">@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]) <br> @lang('lang_v1.aspect_ratio_should_be_1_1')</p></small>
              </div>
          </td>
          @endif
        </tr>
    </table>
</div>